/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.proxy;

import java.lang.reflect.Field;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.client.key.IKeyHandler;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.proxy.ClientProxyComponent;
import org.cyclops.cyclopscore.proxy.CommonProxyComponent;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockEntangledChaliceConfig;
import org.cyclops.evilcraft.client.key.ExaltedCrafterKeyHandler;
import org.cyclops.evilcraft.client.key.FartKeyHandler;
import org.cyclops.evilcraft.client.key.Keys;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityBloodChest;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityBoxOfEternalClosure;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityColossalBloodChest;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityDarkTank;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityDisplayStand;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityEntangledChalice;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityEnvironmentalAccumulator;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityPurifier;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntitySpiritPortal;
import org.cyclops.evilcraft.event.RenderOverlayEventHook;
import org.cyclops.evilcraft.proxy.CommonProxy;

public class ClientProxy
extends ClientProxyComponent {
    public static ModelBakery modelBakery;

    public ClientProxy() {
        super((CommonProxyComponent)new CommonProxy());
        EvilCraft._instance.getModEventBus().addListener(this::onModelBakingCompleted);
    }

    public ModBaseNeoForge<EvilCraft> getMod() {
        return EvilCraft._instance;
    }

    public void registerKeyBindings(IKeyRegistry keyRegistry, RegisterKeyMappingsEvent event) {
        Options settings;
        try {
            Field field = RegisterKeyMappingsEvent.class.getDeclaredField("options");
            field.setAccessible(true);
            settings = (Options)field.get(event);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        for (KeyMapping key : Keys.KEYS) {
            event.register(key);
        }
        FartKeyHandler fartKeyHandler = new FartKeyHandler();
        keyRegistry.addKeyHandler(Keys.FART, (IKeyHandler)fartKeyHandler);
        keyRegistry.addKeyHandler(Keys.EXALTEDCRAFTING, (IKeyHandler)new ExaltedCrafterKeyHandler());
        keyRegistry.addKeyHandler(settings.keyShift, (IKeyHandler)fartKeyHandler);
        EvilCraft.clog("Registered key bindings");
    }

    public void registerEventHooks() {
        super.registerEventHooks();
        NeoForge.EVENT_BUS.register((Object)new RenderOverlayEventHook());
    }

    public void registerRenderers() {
        this.registerRenderer((BlockEntityType)RegistryEntries.BLOCK_ENTITY_BLOOD_CHEST.get(), RenderBlockEntityBloodChest::new);
        this.registerRenderer((BlockEntityType)RegistryEntries.BLOCK_ENTITY_BOX_OF_ETERNAL_CLOSURE.get(), RenderBlockEntityBoxOfEternalClosure::new);
        this.registerRenderer((BlockEntityType)RegistryEntries.BLOCK_ENTITY_COLOSSAL_BLOOD_CHEST.get(), RenderBlockEntityColossalBloodChest::new);
        this.registerRenderer((BlockEntityType)RegistryEntries.BLOCK_ENTITY_DARK_TANK.get(), RenderBlockEntityDarkTank::new);
        this.registerRenderer((BlockEntityType)RegistryEntries.BLOCK_ENTITY_DISPLAY_STAND.get(), RenderBlockEntityDisplayStand::new);
        if (!BlockEntangledChaliceConfig.staticBlockRendering) {
            this.registerRenderer((BlockEntityType)RegistryEntries.BLOCK_ENTITY_ENTANGLED_CHALICE.get(), RenderBlockEntityEntangledChalice::new);
        }
        this.registerRenderer((BlockEntityType)RegistryEntries.BLOCK_ENTITY_ENVIRONMENTAL_ACCUMULATOR.get(), RenderBlockEntityEnvironmentalAccumulator::new);
        this.registerRenderer((BlockEntityType)RegistryEntries.BLOCK_ENTITY_PURIFIER.get(), RenderBlockEntityPurifier::new);
        this.registerRenderer((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SPIRIT_PORTAL.get(), RenderBlockEntitySpiritPortal::new);
        super.registerRenderers();
    }

    public void onModelBakingCompleted(ModelEvent.BakingCompleted event) {
        modelBakery = event.getModelBakery();
    }
}

