/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.cyclops.cyclopscore.helper.IModHelpers;

public abstract class WorldStructurePieceQuarterSymmetrical
extends ScatteredFeaturePiece {
    private final List<Integer> layerHeights = Lists.newArrayList();
    private final List<BlockWrapper[]> layers = Lists.newArrayList();

    protected WorldStructurePieceQuarterSymmetrical(StructurePieceType structurePieceTypeIn, int xIn, int yIn, int zIn, int widthIn, int heightIn, int depthIn, Direction direction) {
        super(structurePieceTypeIn, xIn, yIn, zIn, widthIn, heightIn, depthIn, direction);
        this.generateLayers();
    }

    protected WorldStructurePieceQuarterSymmetrical(StructurePieceType structurePieceTypeIn, CompoundTag nbt) {
        super(structurePieceTypeIn, nbt);
        this.generateLayers();
    }

    protected abstract int getQuarterWidth();

    protected abstract int getQuarterHeight();

    protected abstract void generateLayers();

    protected void addLayer(int height, BlockWrapper[] layer) {
        this.layerHeights.add(height);
        this.layers.add(layer);
    }

    protected void buildCorner(LevelAccessor world, BlockPos blockPos, int incX, int incZ) {
        Random r = new Random();
        for (int i = 0; i < this.layerHeights.size(); ++i) {
            int start;
            int layerHeight = this.layerHeights.get(i);
            BlockWrapper[] layer = this.layers.get(i);
            for (int zr = start = incX == incZ ? 0 : 1; zr < this.getQuarterHeight(); ++zr) {
                for (int xr = start; xr < this.getQuarterWidth(); ++xr) {
                    BlockWrapper wrapper = layer[(this.getQuarterWidth() - xr - 1) * this.getQuarterHeight() + zr];
                    BlockPos posOffset = blockPos.offset(xr * incX, layerHeight, zr * incZ);
                    if (wrapper == null || !(wrapper.chance > 0.0f) || !(wrapper.chance >= r.nextFloat())) continue;
                    world.setBlock(blockPos.offset(xr * incX, layerHeight, zr * incZ), wrapper.blockState, IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
                    if (wrapper.action == null) continue;
                    wrapper.action.run(world, posOffset);
                }
            }
        }
        this.postBuildCorner(world, blockPos, incX, incZ);
    }

    protected void postBuildCorner(LevelAccessor world, BlockPos pos, int incX, int incZ) {
        for (int i = 0; i < this.layerHeights.size(); ++i) {
            int start;
            int layerHeight = this.layerHeights.get(i);
            BlockWrapper[] layer = this.layers.get(i);
            for (int zr = start = incX == incZ ? 0 : 1; zr < this.getQuarterHeight(); ++zr) {
                for (int xr = start; xr < this.getQuarterWidth(); ++xr) {
                    BlockWrapper wrapper = layer[(this.getQuarterWidth() - xr - 1) * this.getQuarterHeight() + zr];
                    if (wrapper == null) continue;
                    BlockPos posOffset = pos.offset(xr * incX, layerHeight, zr * incZ);
                    if (wrapper.action == null || world.getBlockState(posOffset) != wrapper.blockState) continue;
                    wrapper.action.run(world, posOffset);
                }
            }
        }
    }

    public void postProcess(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, BoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
        int x = rand.nextInt(16);
        int z = rand.nextInt(16);
        BlockPos blockPos = new BlockPos(this.getWorldX(x, z), this.getWorldY(0), this.getWorldZ(x, z));
        this.buildCorner((LevelAccessor)world, blockPos, 1, 1);
        this.buildCorner((LevelAccessor)world, blockPos, -1, 1);
        this.buildCorner((LevelAccessor)world, blockPos, 1, -1);
        this.buildCorner((LevelAccessor)world, blockPos, -1, -1);
    }

    public class BlockWrapper {
        public BlockState blockState;
        public float chance = 1.0f;
        public IBlockAction action = null;

        public BlockWrapper(WorldStructurePieceQuarterSymmetrical this$0, Block block) {
            this(this$0, block.defaultBlockState());
        }

        public BlockWrapper(WorldStructurePieceQuarterSymmetrical this$0, BlockState blockState) {
            this.blockState = blockState;
        }

        public BlockWrapper(WorldStructurePieceQuarterSymmetrical this$0, BlockState blockState, float chance) {
            this(this$0, blockState);
            this.chance = chance;
        }
    }

    public static interface IBlockAction {
        public void run(LevelAccessor var1, BlockPos var2);
    }
}

