/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator;

import com.google.common.collect.Maps;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;

public abstract class CommonEnvironmentalAccumulatorRecipeCategory
implements IRecipeCategory<RecipeHolder<RecipeEnvironmentalAccumulator>> {
    private final Map<WeatherType, IDrawableStatic> weatherIcons;
    private final Pair<Integer, Integer> weatherInPos;
    private final Pair<Integer, Integer> weatherOutPos;
    private RecipeHolder<RecipeEnvironmentalAccumulator> lastRecipe = null;

    public CommonEnvironmentalAccumulatorRecipeCategory(IGuiHelper guiHelper, Pair<Integer, Integer> weatherInPos, Pair<Integer, Integer> weatherOutPos) {
        this.weatherInPos = weatherInPos;
        this.weatherOutPos = weatherOutPos;
        this.weatherIcons = Maps.newHashMap();
        ResourceLocation weatherResourceLocation = ResourceLocation.parse((String)"evilcraft:textures/gui/weathers.png");
        this.weatherIcons.put(WeatherType.CLEAR, guiHelper.createDrawable(weatherResourceLocation, 0, 0, 16, 16));
        this.weatherIcons.put(WeatherType.RAIN, guiHelper.createDrawable(weatherResourceLocation, 16, 0, 16, 16));
        this.weatherIcons.put(WeatherType.LIGHTNING, guiHelper.createDrawable(weatherResourceLocation, 32, 0, 16, 16));
    }

    public void draw(RecipeHolder<RecipeEnvironmentalAccumulator> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.lastRecipe != null) {
            if (((RecipeEnvironmentalAccumulator)this.lastRecipe.value()).getInputWeather() != WeatherType.ANY) {
                this.weatherIcons.get(((RecipeEnvironmentalAccumulator)this.lastRecipe.value()).getInputWeather()).draw(guiGraphics, ((Integer)this.weatherInPos.getLeft()).intValue(), ((Integer)this.weatherInPos.getRight()).intValue());
            }
            if (((RecipeEnvironmentalAccumulator)this.lastRecipe.value()).getOutputWeather() != WeatherType.ANY) {
                this.weatherIcons.get(((RecipeEnvironmentalAccumulator)this.lastRecipe.value()).getOutputWeather()).draw(guiGraphics, ((Integer)this.weatherOutPos.getLeft()).intValue(), ((Integer)this.weatherOutPos.getRight()).intValue());
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<RecipeEnvironmentalAccumulator> recipe, IFocusGroup focuses) {
        this.lastRecipe = recipe;
    }
}

