/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.spiritfurnace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSpiritFurnaceConfig;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraftcompat.modcompat.jei.spiritreanimator.SpiritReanimatorRecipeJEI;

public class SpiritFurnaceRecipeJEI {
    private final FluidStack inputFluid;
    private final ItemStack inputItem;
    private final List<ItemStack> outputItems;
    private final int duration;

    public SpiritFurnaceRecipeJEI(FluidStack inputFluid, ItemStack inputItem, List<ItemStack> outputItems, int duration) {
        this.inputFluid = inputFluid;
        this.inputItem = inputItem;
        this.outputItems = outputItems;
        this.duration = duration;
    }

    public static SpiritFurnaceRecipeJEI create(EntityType<?> entityType, LivingEntity entity, ServerLevel level) {
        int duration = SpiritFurnaceRecipeJEI.getRequiredTicks((Entity)entity);
        return new SpiritFurnaceRecipeJEI(new FluidStack(RegistryEntries.FLUID_BLOOD, duration * BlockSpiritFurnaceConfig.mBPerTick), SpiritReanimatorRecipeJEI.getBox(entityType), SpiritFurnaceRecipeJEI.getMobDrops(entityType, (Entity)entity, level), SpiritFurnaceRecipeJEI.getRequiredTicks((Entity)entity));
    }

    public static List<ItemStack> getMobDrops(EntityType<?> entityType, Entity entity, ServerLevel level) {
        ArrayList items = Lists.newArrayList();
        FakePlayer killerEntity = FakePlayerFactory.getMinecraft((ServerLevel)level);
        LootParams.Builder lootParamsBuilder = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)Vec3.ZERO).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)killerEntity).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)killerEntity).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)killerEntity.damageSources().generic()).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)killerEntity);
        LootParams params = lootParamsBuilder.create(LootContextParamSets.ENTITY);
        LootContext context = new LootContext.Builder(params).create(entityType.getDefaultLootTable().map(ResourceKey::location));
        entityType.getDefaultLootTable().ifPresent(lootTableKey -> {
            LootTable lootTable = ServerLifecycleHooks.getCurrentServer().reloadableRegistries().getLootTable(lootTableKey);
            for (LootPool pool : lootTable.pools) {
                for (LootPoolEntryContainer entryContainer : pool.entries) {
                    entryContainer.expand(context, entry -> entry.createItemStack(items::add, context));
                }
            }
        });
        return items;
    }

    public static int getRequiredTicks(Entity entity) {
        int requiredTicksBase;
        try {
            LivingEntity livingEntity = (LivingEntity)entity;
            requiredTicksBase = (int)((livingEntity.getHealth() + (float)livingEntity.getArmorValue()) * (float)BlockSpiritFurnaceConfig.requiredTicksPerHp);
        }
        catch (RuntimeException var7) {
            requiredTicksBase = 40 * BlockSpiritFurnaceConfig.requiredTicksPerHp;
        }
        return requiredTicksBase;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public ItemStack getInputItem() {
        return this.inputItem;
    }

    public List<ItemStack> getOutputItems() {
        return this.outputItems;
    }

    public int getDuration() {
        return this.duration;
    }

    public static void encode(SpiritFurnaceRecipeJEI recipe, RegistryFriendlyByteBuf output) {
        FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)output, (Object)recipe.getInputFluid());
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)output, (Object)recipe.getInputItem());
        output.writeInt(recipe.outputItems.size());
        for (ItemStack outputItem : recipe.outputItems) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)output, (Object)outputItem);
        }
        output.writeInt(recipe.duration);
    }

    public static SpiritFurnaceRecipeJEI decode(RegistryFriendlyByteBuf input) {
        FluidStack inputFluid = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)input);
        ItemStack inputItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)input);
        ArrayList outputItems = Lists.newArrayList();
        int outputItemsCount = input.readInt();
        for (int i = 0; i < outputItemsCount; ++i) {
            outputItems.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)input));
        }
        int duration = input.readInt();
        return new SpiritFurnaceRecipeJEI(inputFluid, inputItem, outputItems, duration);
    }

    public static List<SpiritFurnaceRecipeJEI> generateServerRecipes() {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().overworld();
        ArrayList recipes = Lists.newArrayList();
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            try {
                LivingEntity livingEntity;
                Entity entity = entityType.create((Level)level, EntitySpawnReason.SPAWN_ITEM_USE);
                if (!(entity instanceof LivingEntity) || !EntityVengeanceSpirit.canSustain(livingEntity = (LivingEntity)entity)) continue;
                recipes.add(SpiritFurnaceRecipeJEI.create(entityType, livingEntity, level));
            }
            catch (RuntimeException runtimeException) {}
        }
        return recipes;
    }
}

