/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionRegistry;
import org.cyclops.cyclopscore.config.extendedconfig.BlockClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.item.ItemInformationProviderCommon;

public class BlockAction<M extends IModBase>
extends ConfigurableTypeActionRegistry<BlockConfigCommon<M>, Block, M> {
    protected static final List<BlockConfigCommon<?>> MODEL_ENTRIES = Lists.newArrayList();
    protected static final List<BlockConfigCommon<?>> COLOR_ENTRIES = Lists.newArrayList();

    public static <M extends IModBase> void register(@Nullable BiFunction<BlockConfigCommon<M>, Block, ? extends Item> itemBlockConstructor, BlockConfigCommon<M> config, @Nullable Callable<?> callback) {
        BlockAction.register(config, itemBlockConstructor == null ? callback : null);
        if (itemBlockConstructor != null) {
            ItemConfigCommon itemConfig = new ItemConfigCommon(config.getMod(), config.getNamedId(), (iConfig, properties) -> {
                Item itemBlock = (Item)itemBlockConstructor.apply(config, (Block)config.getInstance());
                Objects.requireNonNull(itemBlock, "Received a null item for the item block constructor of " + config.getNamedId());
                return itemBlock;
            });
            config.getMod().getConfigHandler().registerToRegistry(BuiltInRegistries.ITEM, itemConfig, () -> {
                config.setItemInstance((Item)itemConfig.getInstance());
                try {
                    if (callback != null) {
                        callback.call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            });
        }
    }

    @Override
    public void onRegistriesFilled(BlockConfigCommon<M> eConfig) {
        BlockAction.register(eConfig.getItemConstructor(), eConfig, () -> {
            eConfig.onRegistryRegistered();
            this.polish(eConfig);
            return null;
        });
    }

    public static void handleDynamicBlockModel(BlockConfigCommon extendedConfig) {
        MODEL_ENTRIES.add(extendedConfig);
    }

    protected void polish(BlockConfigCommon<M> config) {
        BlockColor blockColorHandler;
        BlockClientConfig<M> clientConfig;
        for (ItemStack itemStack : config.getDefaultCreativeTabEntries()) {
            config.getMod().registerDefaultCreativeTabEntry(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        Item item = config.getItemInstance();
        if (item != null) {
            ItemInformationProviderCommon.registerItem(item);
        }
        if (config.getMod().getModHelpers().getMinecraftHelpers().isClientSide() && (clientConfig = config.getBlockClientConfig()) != null && (blockColorHandler = clientConfig.getBlockColorHandler()) != null) {
            COLOR_ENTRIES.add(config);
        }
    }
}

