/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FormattedCharSequence;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendixClient;

public class InfoSectionClient {
    private final InfoSection infoSection;

    public InfoSectionClient(InfoSection infoSection) {
        this.infoSection = infoSection;
    }

    public void drawScreen(ScreenInfoBook gui, GuiGraphics guiGraphics, int mouseX, int mouseY, int yOffset, int width, int height, int page, int mx, int my, int footnoteOffsetX, int footnoteOffsetY) {
        if (page < this.infoSection.getPages()) {
            Font fontRenderer = gui.getFont();
            List<FormattedCharSequence> lines = this.infoSection.getLocalizedPageLines(page);
            int l = 0;
            if (lines != null) {
                for (FormattedCharSequence line : lines) {
                    guiGraphics.drawString(fontRenderer, line, mouseX, mouseY + yOffset + l * 9, IModHelpers.get().getBaseHelpers().RGBAToInt(0, 0, 0, 255), false);
                    ++l;
                }
            }
            if (this.infoSection.isTitlePage(page)) {
                gui.drawScaledCenteredString(guiGraphics, this.infoSection.getLocalizedTitle(), mouseX, mouseY + yOffset + 10, width, 1.5f, width, gui.getTitleColor());
                gui.drawHorizontalRule(guiGraphics, mouseX + width / 2, mouseY + yOffset);
                gui.drawHorizontalRule(guiGraphics, mouseX + width / 2, mouseY + yOffset + 21);
            }
            gui.drawScaledCenteredString(guiGraphics, this.infoSection.getLocalizedTitle() + " - " + (page + 1) + "/" + this.infoSection.getPages(), mouseX + (page % 2 == 0 ? 1 : -1) * footnoteOffsetX, mouseY + height + footnoteOffsetY, width, 0.6f, (int)((float)width * 0.75f), IModHelpers.get().getBaseHelpers().RGBAToInt(190, 190, 190, 255));
            for (SectionAppendix appendix : this.infoSection.getAppendixes()) {
                if (appendix.getPage() != page) continue;
                ((SectionAppendixClient)appendix.getSectionAppendixClient()).drawScreen(gui, guiGraphics, mouseX, mouseY + yOffset + InfoSection.getAppendixOffsetLine(fontRenderer, appendix), width, height, page, mx, my, true);
            }
        }
    }

    public void postDrawScreen(ScreenInfoBook gui, GuiGraphics guiGraphics, int mouseX, int mouseY, int width, int height, int page, int mx, int my) {
        if (page < this.infoSection.getPages()) {
            Font fontRenderer = gui.getFont();
            for (SectionAppendix appendix : this.infoSection.getAppendixes()) {
                if (appendix.getPage() != page) continue;
                ((SectionAppendixClient)appendix.getSectionAppendixClient()).drawScreen(gui, guiGraphics, mouseX, mouseY + InfoSection.getAppendixOffsetLine(fontRenderer, appendix), width, height, page, mx, my, false);
            }
        }
    }
}

