/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.RegisterGameTestsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.client.key.KeyRegistry;
import org.cyclops.cyclopscore.command.CommandVersion;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.ConfigHandlerNeoForge;
import org.cyclops.cyclopscore.config.ConfigurableTypesNeoForge;
import org.cyclops.cyclopscore.gametest.GameTestLoaderHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.helper.LoggerHelper;
import org.cyclops.cyclopscore.helper.ModBaseCommon;
import org.cyclops.cyclopscore.helper.ModHelpersNeoForge;
import org.cyclops.cyclopscore.modcompat.IMCHandler;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.network.IPacketHandler;
import org.cyclops.cyclopscore.network.PacketHandlerNeoForge;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

public abstract class ModBaseNeoForge<T extends ModBaseNeoForge<T>>
extends ModBaseCommon<T> {
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_GUI;
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_MODELS;
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_SKINS;
    public static final EnumReferenceKey<Boolean> REFKEY_RETROGEN;
    public static final EnumReferenceKey<Boolean> REFKEY_CRASH_ON_INVALID_RECIPE;
    public static final EnumReferenceKey<Boolean> REFKEY_CRASH_ON_MODCOMPAT_CRASH;
    public static final EnumReferenceKey<Boolean> REFKEY_INFOBOOK_REWARDS;
    private final ICommonProxy proxy;
    private final ConfigHandlerCommon configHandler;
    private final Map<EnumReferenceKey<?>, Object> genericReference = Maps.newHashMap();
    private final List<WorldStorage.Access<?>> worldStorages = Lists.newLinkedList();
    private final IKeyRegistry keyRegistry;
    private final PacketHandlerNeoForge packetHandler;
    private final CapabilityConstructorRegistry capabilityConstructorRegistry;
    private final IMCHandler imcHandler;
    private final IEventBus modEventBus;
    private ModContainer container;

    public ModBaseNeoForge(String modId, Consumer<T> instanceSetter, IEventBus modEventBus) {
        super(modId, instanceSetter);
        this.modEventBus = modEventBus;
        this.proxy = this.getModHelpers().getMinecraftHelpers().isClientSide() ? this.constructClientProxy() : this.constructCommonProxy();
        this.configHandler = this.constructConfigHandler();
        this.keyRegistry = new KeyRegistry();
        this.packetHandler = this.constructPacketHandler();
        this.capabilityConstructorRegistry = this.constructCapabilityConstructorRegistry();
        this.imcHandler = this.constructIMCHandler();
        this.getModEventBus().addListener(this::setup);
        this.getModEventBus().addListener(EventPriority.LOWEST, this::afterRegistriesCreated);
        this.getModEventBus().addListener(EventPriority.HIGHEST, this::beforeRegistriedFilled);
        this.getModEventBus().addListener(this::registerGameTests);
        if (this.getModHelpers().getMinecraftHelpers().isClientSide()) {
            this.getModEventBus().addListener(this::setupClient);
            this.getModEventBus().addListener(this::onRegisterKeyMappings);
        }
        NeoForge.EVENT_BUS.addListener(this::onServerStarting);
        NeoForge.EVENT_BUS.addListener(this::onServerStarted);
        NeoForge.EVENT_BUS.addListener(this::onServerStopping);
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
        this.populateDefaultGenericReferences();
        this.onConfigsRegister(this.getConfigHandler());
        ((ConfigHandlerNeoForge)this.getConfigHandler()).initialize(Lists.newArrayList());
        this.getConfigHandler().loadModInit();
        this.loadModCompats(this.getModCompatLoader());
    }

    @Override
    protected abstract IClientProxy constructClientProxy();

    @Override
    protected abstract ICommonProxy constructCommonProxy();

    @Override
    public IModHelpersNeoForge getModHelpers() {
        return ModHelpersNeoForge.INSTANCE;
    }

    @Override
    public ICommonProxy getProxy() {
        return this.proxy;
    }

    @Override
    public ConfigHandlerCommon getConfigHandler() {
        return this.configHandler;
    }

    public Map<EnumReferenceKey<?>, Object> getGenericReference() {
        return this.genericReference;
    }

    public List<WorldStorage.Access<?>> getWorldStorages() {
        return this.worldStorages;
    }

    public IKeyRegistry getKeyRegistry() {
        return this.keyRegistry;
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public CapabilityConstructorRegistry getCapabilityConstructorRegistry() {
        return this.capabilityConstructorRegistry;
    }

    public IMCHandler getImcHandler() {
        return this.imcHandler;
    }

    public String getModName() {
        return this.getContainer().getModInfo().getDisplayName();
    }

    public IEventBus getModEventBus() {
        return this.modEventBus;
    }

    public ModContainer getContainer() {
        if (this.container == null) {
            this.container = (ModContainer)ModList.get().getModContainerById(this.getModId()).get();
        }
        return this.container;
    }

    @Override
    protected LoggerHelper constructLoggerHelper() {
        return new LoggerHelper(this.getModId());
    }

    protected ConfigHandlerCommon constructConfigHandler() {
        return new ConfigHandlerNeoForge(this);
    }

    protected PacketHandlerNeoForge constructPacketHandler() {
        return new PacketHandlerNeoForge(this);
    }

    protected CapabilityConstructorRegistry constructCapabilityConstructorRegistry() {
        return new CapabilityConstructorRegistry(this);
    }

    protected IMCHandler constructIMCHandler() {
        return new IMCHandler(this);
    }

    @Override
    protected LiteralArgumentBuilder<CommandSourceStack> constructBaseCommand(Commands.CommandSelection selection, CommandBuildContext context) {
        LiteralArgumentBuilder<CommandSourceStack> root = super.constructBaseCommand(selection, context);
        root.then(CommandVersion.make(this));
        return root;
    }

    public <T> void putGenericReference(EnumReferenceKey<T> key, T value) {
        this.genericReference.put(key, value);
    }

    private void populateDefaultGenericReferences() {
        this.putGenericReference(REFKEY_TEXTURE_PATH_GUI, "textures/gui/");
        this.putGenericReference(REFKEY_TEXTURE_PATH_MODELS, "textures/models/");
        this.putGenericReference(REFKEY_TEXTURE_PATH_SKINS, "textures/skins/");
        this.putGenericReference(REFKEY_RETROGEN, false);
        this.putGenericReference(REFKEY_CRASH_ON_INVALID_RECIPE, false);
        this.putGenericReference(REFKEY_CRASH_ON_MODCOMPAT_CRASH, false);
        this.putGenericReference(REFKEY_INFOBOOK_REWARDS, true);
    }

    public <T> T getReferenceValue(EnumReferenceKey<T> key) {
        if (!this.genericReference.containsKey(key)) {
            throw new IllegalArgumentException("Could not find " + String.valueOf(key) + " as generic reference item.");
        }
        return (T)this.genericReference.get(key);
    }

    protected void setup(FMLCommonSetupEvent event) {
        this.log(Level.TRACE, "setup()");
        this.getConfigHandler().loadSetup();
        ICommonProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerEventHooks();
            proxy.registerPackets(this.getPacketHandler());
            proxy.registerTickHandlers();
        }
    }

    protected void setupClient(FMLClientSetupEvent event) {
        ICommonProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerRenderers();
        }
    }

    protected void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        ICommonProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerKeyBindings(this.getKeyRegistry(), event);
        }
    }

    private void afterRegistriesCreated(NewRegistryEvent event) {
        this.getConfigHandler().loadRegistriesCreated();
    }

    private void beforeRegistriedFilled(RegisterEvent event) {
        if (event.getRegistryKey().equals(BuiltInRegistries.ATTRIBUTE.key())) {
            this.getConfigHandler().loadRegistriesFilled();
        }
    }

    protected void registerGameTests(RegisterGameTestsEvent event) {
        if (!GameTestLoaderHelpers.areGameTestsEnabled(this.getModId())) {
            return;
        }
        try {
            Field field = RegisterGameTestsEvent.class.getDeclaredField("environmentsRegistry");
            field.setAccessible(true);
            Registry testEnvironmentRegistry = (Registry)field.get(event);
            GameTestLoaderHelpers.registerCommonTests(this.getModId(), this.getGameTestClasses(), (arg_0, arg_1) -> ((RegisterGameTestsEvent)event).registerTest(arg_0, arg_1), (Registry<TestEnvironmentDefinition>)testEnvironmentRegistry);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected void onServerStarting(ServerStartingEvent event) {
    }

    protected void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(this.constructBaseCommand(event.getCommandSelection(), event.getBuildContext()));
    }

    protected void onServerStarted(ServerStartedEvent event) {
        for (WorldStorage.Access<?> worldStorage : this.worldStorages) {
            worldStorage.onStartedEvent(event);
        }
    }

    protected void onServerStopping(ServerStoppingEvent event) {
        for (WorldStorage.Access<?> worldStorage : this.worldStorages) {
            worldStorage.onStoppingEvent(event);
        }
    }

    public void registerWorldStorage(WorldStorage.Access<?> worldStorage) {
        this.worldStorages.add(worldStorage);
    }

    @Nullable
    public static ModBaseNeoForge get(String modId) {
        return (ModBaseNeoForge)ModBaseCommon.getCommon(modId);
    }

    public static Map<String, ModBaseNeoForge<?>> getMods() {
        return ModBaseCommon.getCommonMods();
    }

    static {
        ConfigurableTypesNeoForge.load();
        REFKEY_TEXTURE_PATH_GUI = EnumReferenceKey.create("texture_path_gui", String.class);
        REFKEY_TEXTURE_PATH_MODELS = EnumReferenceKey.create("texture_path_models", String.class);
        REFKEY_TEXTURE_PATH_SKINS = EnumReferenceKey.create("texture_path_skins", String.class);
        REFKEY_RETROGEN = EnumReferenceKey.create("retrogen", Boolean.class);
        REFKEY_CRASH_ON_INVALID_RECIPE = EnumReferenceKey.create("crash_on_invalid_recipe", Boolean.class);
        REFKEY_CRASH_ON_MODCOMPAT_CRASH = EnumReferenceKey.create("crash_on_modcompat_crash", Boolean.class);
        REFKEY_INFOBOOK_REWARDS = EnumReferenceKey.create("rewards", Boolean.class);
    }

    public static class EnumReferenceKey<T> {
        private final String key;
        private final Class<T> type;

        private EnumReferenceKey(String key, Class<T> type) {
            this.key = key;
            this.type = type;
        }

        public static <T> EnumReferenceKey<T> create(String key, Class<T> type) {
            return new EnumReferenceKey<T>(key, type);
        }

        public String getKey() {
            return this.key;
        }

        public Class<T> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumReferenceKey)) {
                return false;
            }
            EnumReferenceKey other = (EnumReferenceKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Class<T> this$type = this.getType();
            Class<T> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnumReferenceKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Class<T> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ModBaseNeoForge.EnumReferenceKey(key=" + this.getKey() + ", type=" + String.valueOf(this.getType()) + ")";
        }
    }
}

