/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.capabilities;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.modcompat.capabilities.IBlockCapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityTypeGetter;

public class CapabilityConstructorRegistry {
    private final List<Pair<Supplier<BlockEntityType<? extends BlockEntity>>, ICapabilityConstructor<?, ?, ?, ? extends BlockEntityType<? extends BlockEntity>>>> capabilityConstructorsBlockEntity = Lists.newArrayList();
    private final List<Pair<Supplier<? extends Block>, IBlockCapabilityConstructor<?, ?, ?, ? extends Block>>> capabilityConstructorsBlock = Lists.newArrayList();
    private final List<Pair<Supplier<EntityType<? extends Entity>>, ICapabilityConstructor<?, ?, ?, ? extends EntityType<? extends Entity>>>> capabilityConstructorsEntity = Lists.newArrayList();
    private final List<Pair<Supplier<ItemLike>, ICapabilityConstructor<?, ?, ?, ? extends ItemLike>>> capabilityConstructorsItem = Lists.newArrayList();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?, ?>>> capabilityConstructorsBlockEntitySuper = Sets.newHashSet();
    private Collection<Pair<Class<?>, IBlockCapabilityConstructor<?, ?, ?, ?>>> capabilityConstructorsBlockSuper = Sets.newHashSet();
    private Collection<Pair<MobCategory, ICapabilityConstructor<?, ?, ?, ? extends EntityType<? extends Entity>>>> capabilityConstructorsEntityCategory = Sets.newHashSet();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?, ?>>> capabilityConstructorsItemSuper = Sets.newHashSet();
    protected final ModBaseNeoForge mod;
    protected boolean baked = false;
    protected boolean registeredBlockEntityEventListener = false;
    protected boolean registeredBlockEventListener = false;
    protected boolean registeredEntityEventListener = false;
    protected boolean registeredItemStackEventListener = false;

    public CapabilityConstructorRegistry(ModBaseNeoForge mod) {
        this.mod = mod;
    }

    protected ModBaseNeoForge getMod() {
        return this.mod;
    }

    protected void checkNotBaked() {
        if (this.baked) {
            throw new IllegalStateException("Please register capabilities before pre-init.");
        }
    }

    public <T extends BlockEntity> void registerBlockEntity(Supplier<BlockEntityType<T>> blockEntityType, ICapabilityConstructor<?, ?, ?, BlockEntityType<T>> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsBlockEntity.add(Pair.of(blockEntityType, constructor));
        if (!this.registeredBlockEntityEventListener) {
            this.registeredBlockEntityEventListener = true;
            this.mod.getModEventBus().register((Object)new BlockEntityEventListener());
        }
    }

    public <T extends Block> void registerBlock(Supplier<T> block, IBlockCapabilityConstructor<?, ?, ?, T> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsBlock.add(Pair.of(block, constructor));
        if (!this.registeredBlockEventListener) {
            this.registeredBlockEventListener = true;
            this.mod.getModEventBus().register((Object)new BlockEventListener());
        }
    }

    public <T extends Entity> void registerEntity(Supplier<EntityType<T>> entityType, ICapabilityConstructor<?, ?, ?, ? extends EntityType<T>> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsEntity.add(Pair.of(entityType, constructor));
        if (!this.registeredEntityEventListener) {
            this.registeredEntityEventListener = true;
            this.mod.getModEventBus().register((Object)new EntityEventListener());
        }
    }

    public void registerItem(Supplier<ItemLike> item, ICapabilityConstructor<?, ?, ?, ? extends ItemLike> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsItem.add(Pair.of(item, constructor));
        if (!this.registeredItemStackEventListener) {
            this.registeredItemStackEventListener = true;
            this.mod.getModEventBus().register((Object)new ItemStackEventListener());
        }
    }

    public void registerInheritableBlockEntity(Class<?> clazz, ICapabilityConstructor<?, ?, ?, ?> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsBlockEntitySuper.add(Pair.of(clazz, constructor));
        if (!this.registeredBlockEntityEventListener) {
            this.registeredBlockEntityEventListener = true;
            this.mod.getModEventBus().register((Object)new BlockEntityEventListener());
        }
    }

    public void registerInheritableBlock(Class<?> clazz, IBlockCapabilityConstructor<?, ?, ?, ?> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsBlockSuper.add(Pair.of(clazz, constructor));
        if (!this.registeredBlockEventListener) {
            this.registeredBlockEventListener = true;
            this.mod.getModEventBus().register((Object)new BlockEventListener());
        }
    }

    public void registerMobCategoryEntity(MobCategory mobCategory, ICapabilityConstructor<?, ?, ?, ? extends EntityType<? extends Entity>> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsEntityCategory.add(Pair.of((Object)mobCategory, constructor));
        if (!this.registeredEntityEventListener) {
            this.registeredEntityEventListener = true;
            this.mod.getModEventBus().register((Object)new EntityEventListener());
        }
    }

    public void registerInheritableItem(Class<?> clazz, ICapabilityConstructor<?, ?, ?, ?> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsItemSuper.add(Pair.of(clazz, constructor));
        if (!this.registeredItemStackEventListener) {
            this.registeredItemStackEventListener = true;
            this.mod.getModEventBus().register((Object)new ItemStackEventListener());
        }
    }

    protected <CK> ICapabilityProvider<?, ?, ?> createProvider(CK capabilityKey, ICapabilityConstructor<?, ?, ?, CK> capabilityConstructor) {
        return capabilityConstructor.createProvider(capabilityKey);
    }

    protected <CK> IBlockCapabilityProvider<?, ?> createProviderBlock(CK capabilityKey, IBlockCapabilityConstructor<?, ?, ?, CK> capabilityConstructor) {
        return capabilityConstructor.createProvider(capabilityKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <CK> void onLoad(List<Pair<Supplier<CK>, ICapabilityConstructor<?, ?, ?, CK>>> allConstructors, RegisterCapabilitiesEvent event) {
        CapabilityConstructorRegistry capabilityConstructorRegistry = this;
        synchronized (capabilityConstructorRegistry) {
            if (!this.baked) {
                this.bake();
            }
        }
        for (Pair pair : allConstructors) {
            this.addLoadedCapabilityProvider(event, ((Supplier)pair.getKey()).get(), (ICapabilityTypeGetter)pair.getValue());
        }
    }

    protected <CK> void addLoadedCapabilityProvider(RegisterCapabilitiesEvent event, CK capabilityKey, ICapabilityTypeGetter<?, ?> constructor) {
        BaseCapability<?, ?> capability = constructor.getCapability();
        if (capabilityKey instanceof BlockEntityType) {
            BlockEntityType blockEntityType = (BlockEntityType)capabilityKey;
            ICapabilityProvider<?, ?, ?> provider = this.createProvider(capabilityKey, (ICapabilityConstructor)constructor);
            if (provider != null) {
                event.registerBlockEntity((BlockCapability)capability, blockEntityType, provider);
            }
        } else if (capabilityKey instanceof Block) {
            Block block = (Block)capabilityKey;
            IBlockCapabilityProvider<?, ?> provider = this.createProviderBlock(capabilityKey, (IBlockCapabilityConstructor)constructor);
            if (provider != null) {
                event.registerBlock((BlockCapability)capability, provider, new Block[]{block});
            }
        } else if (capabilityKey instanceof EntityType) {
            EntityType entityType = (EntityType)capabilityKey;
            ICapabilityProvider<?, ?, ?> provider = this.createProvider(capabilityKey, (ICapabilityConstructor)constructor);
            if (provider != null) {
                event.registerEntity((EntityCapability)capability, entityType, provider);
            }
        } else if (capabilityKey instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)capabilityKey;
            ICapabilityProvider<?, ?, ?> provider = this.createProvider(capabilityKey, (ICapabilityConstructor)constructor);
            if (provider != null) {
                event.registerItem((ItemCapability)capability, provider, new ItemLike[]{itemLike});
            }
        } else {
            throw new IllegalStateException("Capability of type " + String.valueOf(capability.getClass()) + " is not supported");
        }
    }

    public void bake() {
        this.baked = true;
        this.bakeCapabilityConstructorsSuper(this.capabilityConstructorsBlockEntitySuper, this.capabilityConstructorsBlockEntity);
        this.bakeCapabilityConstructorsSuper(this.capabilityConstructorsItemSuper, this.capabilityConstructorsItem);
        for (Pair<Class<?>, IBlockCapabilityConstructor<?, ?, ?, ?>> pair : this.capabilityConstructorsBlockSuper) {
            Class type = (Class)pair.getLeft();
            BuiltInRegistries.BLOCK.forEach(block -> {
                if (type.isInstance(block)) {
                    this.capabilityConstructorsBlock.add(Pair.of(() -> block, (Object)((IBlockCapabilityConstructor)pair.getRight())));
                }
            });
        }
        for (Pair pair : this.capabilityConstructorsEntityCategory) {
            MobCategory category = (MobCategory)pair.getLeft();
            BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
                if (entityType.getCategory() == category) {
                    this.capabilityConstructorsEntity.add(Pair.of(() -> entityType, (Object)((ICapabilityConstructor)pair.getRight())));
                }
            });
        }
        this.capabilityConstructorsBlockEntitySuper = null;
        this.capabilityConstructorsBlockSuper = null;
        this.capabilityConstructorsItemSuper = null;
        this.capabilityConstructorsEntityCategory = null;
    }

    protected <CK> void bakeCapabilityConstructorsSuper(Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?, CK>>> allInheritableConstructors, List<Pair<Supplier<CK>, ICapabilityConstructor<?, ?, ?, CK>>> allConstructors) {
        for (Pair entry : allInheritableConstructors) {
            Class type = (Class)entry.getLeft();
            if (BlockEntity.class.isAssignableFrom(type)) {
                BuiltInRegistries.BLOCK_ENTITY_TYPE.forEach(blockEntityType -> {
                    if (type.isInstance(blockEntityType)) {
                        allConstructors.add(Pair.of(() -> blockEntityType, (Object)((ICapabilityConstructor)entry.getRight())));
                    }
                });
                continue;
            }
            if (Item.class.isAssignableFrom(type)) {
                BuiltInRegistries.ITEM.forEach(item -> {
                    if (type.isInstance(item)) {
                        allConstructors.add(Pair.of(() -> item, (Object)((ICapabilityConstructor)entry.getRight())));
                    }
                });
                continue;
            }
            throw new IllegalStateException("Capability of type " + String.valueOf(type) + " is not supported");
        }
    }

    public class BlockEntityEventListener {
        @SubscribeEvent
        public void onBlockEntityLoad(RegisterCapabilitiesEvent event) {
            CapabilityConstructorRegistry.this.onLoad(CapabilityConstructorRegistry.this.capabilityConstructorsBlockEntity, event);
        }
    }

    public class BlockEventListener {
        @SubscribeEvent
        public void onBlockLoad(RegisterCapabilitiesEvent event) {
            CapabilityConstructorRegistry.this.onLoad(CapabilityConstructorRegistry.this.capabilityConstructorsBlock, event);
        }
    }

    public class EntityEventListener {
        @SubscribeEvent
        public void onEntityLoad(RegisterCapabilitiesEvent event) {
            CapabilityConstructorRegistry.this.onLoad(CapabilityConstructorRegistry.this.capabilityConstructorsEntity, event);
        }
    }

    public class ItemStackEventListener {
        @SubscribeEvent
        public void onItemStackLoad(RegisterCapabilitiesEvent event) {
            CapabilityConstructorRegistry.this.onLoad(CapabilityConstructorRegistry.this.capabilityConstructorsItem, event);
        }
    }
}

