/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.packet.PlayerPositionPacket;

public class RingOfFirePacket
extends PlayerPositionPacket<RingOfFirePacket> {
    public static final CustomPacketPayload.Type<RingOfFirePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cyclopscore", (String)"ring_of_fire"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RingOfFirePacket> CODEC = PacketBase.getCodec(RingOfFirePacket::new);
    private static final double RING_AREA = (double)0.9f;

    public RingOfFirePacket() {
        super(TYPE);
    }

    public RingOfFirePacket(Player player) {
        super(TYPE, player);
    }

    private static void showFireRing(Level world, Vec3 pos) {
        double area = 0.9f;
        int points = 40;
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            double u = Math.PI * 2 * (point / (double)points);
            double xOffset = Math.cos(u) * area;
            double yOffset = 0.0;
            double zOffset = Math.sin(u) * area;
            double x = pos.x;
            double y = pos.y;
            double z = pos.z;
            double particleX = x + xOffset + (double)(world.random.nextFloat() / 5.0f);
            double particleY = y + yOffset + (double)(world.random.nextFloat() / 5.0f);
            double particleZ = z + zOffset + (double)(world.random.nextFloat() / 5.0f);
            float particleMotionX = (float)xOffset / 50.0f;
            float particleMotionY = 0.01f;
            float particleMotionZ = (float)zOffset / 50.0f;
            if (world.random.nextInt(20) == 0) {
                world.addParticle((ParticleOptions)ParticleTypes.LAVA, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                continue;
            }
            world.addParticle((ParticleOptions)ParticleTypes.FLAME, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    @Override
    protected PlayerPositionPacket<RingOfFirePacket> create(Player player, int range) {
        return new RingOfFirePacket(player);
    }

    @Override
    protected IModBase getModInstance() {
        return CyclopsCoreInstance.MOD;
    }

    @Override
    protected void performClientAction(Level level, Player player) {
        RingOfFirePacket.showFireRing(level, this.position);
    }
}

