/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.world;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.persist.world.WorldStorage;

public class GlobalCounters
extends WorldStorage<GlobalCounters> {
    private final Map<String, Integer> counters;

    public GlobalCounters(Map<String, Integer> counters) {
        this.counters = Maps.newHashMap(counters);
    }

    public synchronized int getNext(String key) {
        int incr;
        Integer nextObject = this.counters.get(key);
        int next = 0;
        if (nextObject != null) {
            next = nextObject;
        }
        if ((incr = next + 1) < 0) {
            incr = 0;
        }
        this.counters.put(key, incr);
        this.setDirty();
        return next;
    }

    public static class Access
    extends WorldStorage.Access<GlobalCounters> {
        public Access(ModBaseNeoForge<?> mod) {
            super(new SavedDataType(mod.getModId() + "_globalcounters", ctx -> new GlobalCounters(Maps.newHashMap()), ctx -> RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)ctx.levelOrThrow()), (App)Codec.dispatchedMap((Codec)Codec.STRING, key -> Codec.INT).fieldOf("counters").forGetter(data -> data.counters)).apply((Applicative)instance, (level, counters) -> new GlobalCounters((Map<String, Integer>)counters)))), mod);
        }
    }
}

