/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class ArgumentTypeEnum<T extends Enum<T>>
implements ArgumentType<T> {
    private final Class<T> enumClass;

    public ArgumentTypeEnum(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        try {
            return Enum.valueOf(this.enumClass, reader.readString().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Unknown value")).create();
        }
    }

    public Collection<String> getExamples() {
        return Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(this.getExamples(), (SuggestionsBuilder)builder);
    }

    public static <T extends Enum<T>> T getValue(CommandContext<CommandSourceStack> context, String name, Class<T> enumClass) {
        return (T)((Enum)context.getArgument(name, enumClass));
    }

    public static class Info
    implements ArgumentTypeInfo<ArgumentTypeEnum<?>, Template<?>> {
        public void serializeToNetwork(Template<?> argumentTypeEnum, FriendlyByteBuf packetBuffer) {
            packetBuffer.m_130070_(argumentTypeEnum.enumClass.getName());
        }

        public Template deserializeFromNetwork(FriendlyByteBuf packetBuffer) {
            try {
                return new Template(Class.forName(packetBuffer.m_130136_(Short.MAX_VALUE)));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void serializeToJson(Template<?> argumentTypeEnum, JsonObject jsonObject) {
            jsonObject.addProperty("class", argumentTypeEnum.enumClass.getName());
        }

        public Template<?> unpack(ArgumentTypeEnum<?> arg) {
            return new Template(arg.enumClass);
        }

        public final class Template<T extends Enum<T>>
        implements ArgumentTypeInfo.Template<ArgumentTypeEnum<?>> {
            private final Class<T> enumClass;

            Template(Class<T> enumClass) {
                this.enumClass = enumClass;
            }

            public ArgumentTypeEnum<?> instantiate(CommandBuildContext p_235533_) {
                return new ArgumentTypeEnum<T>(this.enumClass);
            }

            public ArgumentTypeInfo<ArgumentTypeEnum<?>, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

