/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionForge;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class BlockAction
extends ConfigurableTypeActionForge<BlockConfig, Block> {
    private static final List<BlockConfig> MODEL_ENTRIES = Lists.newArrayList();

    public static void register(@Nullable BiFunction<BlockConfig, Block, ? extends Item> itemBlockConstructor, BlockConfig config, @Nullable Callable<?> callback) {
        BlockAction.register(config, itemBlockConstructor == null ? callback : null);
        if (itemBlockConstructor != null) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
                if (event.getRegistryKey().equals((Object)ForgeRegistries.ITEMS.getRegistryKey())) {
                    Item itemBlock = (Item)itemBlockConstructor.apply(config, (Block)config.getInstance());
                    Objects.requireNonNull(itemBlock, "Received a null item for the item block constructor of " + config.getNamedId());
                    event.getForgeRegistry().register(new ResourceLocation(config.getMod().getModId(), config.getNamedId()), (Object)itemBlock);
                    config.setItemInstance(itemBlock);
                    try {
                        if (callback != null) {
                            callback.call();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public void onRegisterForgeFilled(BlockConfig eConfig) {
        BlockAction.register(eConfig.getItemConstructor(), eConfig, () -> {
            eConfig.onForgeRegistered();
            this.polish(eConfig);
            return null;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistryLoad(ModelEvent.RegisterAdditional event) {
        for (BlockConfig config : MODEL_ENTRIES) {
            Pair<ModelResourceLocation, ModelResourceLocation> resourceLocations = config.registerDynamicModel();
            config.dynamicBlockVariantLocation = (ModelResourceLocation)resourceLocations.getLeft();
            config.dynamicItemVariantLocation = (ModelResourceLocation)resourceLocations.getRight();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (BlockConfig config : MODEL_ENTRIES) {
            IDynamicModelElement dynamicModelElement = (IDynamicModelElement)config.getInstance();
            BakedModel dynamicModel = dynamicModelElement.createDynamicModel(event);
            if (config.dynamicBlockVariantLocation != null) {
                event.getModels().put(config.dynamicBlockVariantLocation, dynamicModel);
            }
            if (config.dynamicItemVariantLocation == null) continue;
            event.getModels().put(config.dynamicItemVariantLocation, dynamicModel);
        }
    }

    public static void handleDynamicBlockModel(BlockConfig extendedConfig) {
        MODEL_ENTRIES.add(extendedConfig);
    }

    protected void polish(BlockConfig config) {
        BlockColor blockColorHandler;
        Block block = (Block)config.getInstance();
        if (MinecraftHelpers.isClientSide() && (blockColorHandler = config.getBlockColorHandler()) != null) {
            Minecraft.m_91087_().m_91298_().m_92589_(blockColorHandler, new Block[]{block});
        }
    }

    static {
        if (MinecraftHelpers.isClientSide()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(BlockAction::onModelRegistryLoad);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(BlockAction::onModelBakeEvent);
        }
    }
}

