/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.network.packet.RequestPlayerAdvancementUnlockedPacket;

public class AdvancementHelpers {
    public static final Set<ResourceLocation> ACHIEVED_ADVANCEMENTS = Sets.newHashSet();

    public static boolean hasAdvancementUnlocked(Player player, Advancement advancement) {
        return player instanceof ServerPlayer && ((ServerPlayer)player).f_8924_.m_6846_().m_11296_((ServerPlayer)player).m_135996_(advancement).m_8193_();
    }

    public static boolean hasAdvancementUnlocked(Player player, ResourceLocation advancementId) {
        return ACHIEVED_ADVANCEMENTS.contains(advancementId);
    }

    public static void requestAdvancementUnlockInfo(ResourceLocation advancementId) {
        CyclopsCore._instance.getPacketHandler().sendToServer(new RequestPlayerAdvancementUnlockedPacket(advancementId.toString()));
    }

    public static Advancement getAdvancement(Dist dist, ResourceLocation resourceLocation) {
        if (dist.isClient()) {
            return AdvancementHelpers.getAdvancementManagerClient().m_104396_().m_139337_(resourceLocation);
        }
        return AdvancementHelpers.getAdvancementManagerServer().m_136041_(resourceLocation);
    }

    public static ServerAdvancementManager getAdvancementManagerServer() {
        return ServerLifecycleHooks.getCurrentServer().m_129889_();
    }

    public static ClientAdvancements getAdvancementManagerClient() {
        return Minecraft.m_91087_().f_91074_.f_108617_.m_105145_();
    }

    public static <T extends CriterionTrigger<?>> T registerCriteriaTrigger(T criterion) {
        return (T)CriteriaTriggers.m_10595_(criterion);
    }
}

