/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;

public final class L10NHelpers {
    public static final int MAX_TOOLTIP_LINE_LENGTH = 25;
    private static final String KEY_ENABLED = "general.cyclopscore.info.enabled";
    private static final String KEY_DISABLED = "general.cyclopscore.info.disabled";

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String key, Object ... params) {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return I18n.m_118938_((String)key, (Object[])params);
        }
        return String.format("%s: %s", key, Arrays.toString(params));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addStatusInfo(List<Component> infoLines, boolean isEnabled, String statusPrefixKey) {
        MutableComponent autoSupply = Component.m_237115_((String)KEY_DISABLED);
        if (isEnabled) {
            autoSupply = Component.m_237115_((String)KEY_ENABLED);
        }
        infoLines.add((Component)Component.m_237110_((String)statusPrefixKey, (Object[])new Object[]{autoSupply}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addOptionalInfo(List<Component> list, String prefix) {
        String key = prefix + ".info";
        if (I18n.m_118936_((String)key)) {
            if (MinecraftHelpers.isShifted()) {
                String localized = L10NHelpers.localize(key, new Object[0]);
                list.addAll(StringHelpers.splitLines(localized, 25, IInformationProvider.INFO_PREFIX).stream().map(Component::m_237113_).collect(Collectors.toList()));
            } else {
                list.add((Component)Component.m_237115_((String)"general.cyclopscore.tooltip.info").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)).m_131155_(Boolean.valueOf(true))));
            }
        }
    }
}

