/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.recipe;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.CraftingHelpers;

public abstract class RecipeHandlerRecipeType<C extends Container, R extends Recipe<C>>
implements IRecipeHandler {
    private final Supplier<Level> worldSupplier;
    private final RecipeType<R> recipeType;
    private final Set<IngredientComponent<?, ?>> inputComponents;
    private final Set<IngredientComponent<?, ?>> outputComponents;

    public RecipeHandlerRecipeType(Supplier<Level> worldSupplier, RecipeType<R> recipeType, Set<IngredientComponent<?, ?>> inputComponents, Set<IngredientComponent<?, ?>> outputComponents) {
        this.worldSupplier = worldSupplier;
        this.recipeType = recipeType;
        this.inputComponents = inputComponents;
        this.outputComponents = outputComponents;
    }

    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return this.inputComponents;
    }

    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return this.outputComponents;
    }

    public Collection<IRecipeDefinition> getRecipes() {
        return this.worldSupplier.get().m_7465_().m_44054_(this.recipeType).values().stream().map(this::getRecipeDefinition).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public IRecipeDefinition getRecipeDefinition(R recipe) {
        Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs = this.getRecipeInputIngredients(recipe);
        if (inputs == null) {
            return null;
        }
        IMixedIngredients outputs = this.getRecipeOutputIngredients(recipe);
        if (outputs == null) {
            return null;
        }
        return new RecipeDefinition(inputs, outputs);
    }

    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        C container = this.getRecipeInputContainer(input);
        if (container == null) {
            return null;
        }
        Recipe recipe = CraftingHelpers.findRecipeCached(this.recipeType, container, this.worldSupplier.get(), true).orElse(null);
        if (recipe == null) {
            return null;
        }
        return this.getRecipeOutputIngredients(recipe);
    }

    @Nullable
    protected abstract C getRecipeInputContainer(IMixedIngredients var1);

    @Nullable
    protected abstract Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> getRecipeInputIngredients(R var1);

    @Nullable
    protected abstract IMixedIngredients getRecipeOutputIngredients(R var1);
}

