/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import java.util.function.Consumer;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.IModVersion;

public abstract class ModBaseVersionable<T extends ModBaseVersionable>
extends ModBase<T>
implements IModVersion {
    private boolean versionInfo = false;
    private String version;
    private String info;
    private String updateUrl;

    public ModBaseVersionable(String modId, Consumer<T> instanceSetter) {
        super(modId, instanceSetter);
    }

    @Override
    public void setVersionInfo(String version, String info, String updateUrl) {
        this.versionInfo = true;
        this.version = version;
        this.info = info;
        this.updateUrl = updateUrl;
    }

    @Override
    public boolean isVersionInfo() {
        return this.versionInfo;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public String getUpdateUrl() {
        return this.updateUrl;
    }

    @Override
    public boolean needsUpdate() {
        ArtifactVersion currentVersion = this.getContainer().getModInfo().getVersion();
        String latestVersionString = this.getVersion();
        if (latestVersionString == null) {
            return false;
        }
        DefaultArtifactVersion newVersion = new DefaultArtifactVersion(latestVersionString);
        return this.getVersion() != null && currentVersion.compareTo((Object)newVersion) < 0;
    }
}

