/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidUtil;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;
import org.cyclops.evilcraft.core.block.IBlockTank;

public class BlockPurifier
extends BlockWithEntity
implements IBlockTank {
    private static final VoxelShape INSIDE = BlockPurifier.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)BlockPurifier.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{BlockPurifier.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), BlockPurifier.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.f_82685_);

    public BlockPurifier(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityPurifier::new);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockPurifier.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_PURIFIER, (BlockEntityTicker)new BlockEntityPurifier.Ticker());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = player.m_150109_().m_36056_();
        BlockEntityPurifier tile = (BlockEntityPurifier)world.m_7702_(blockPos);
        if (tile != null) {
            if (itemStack.m_41619_() && !tile.getPurifyItem().m_41619_()) {
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, tile.getPurifyItem());
                tile.setPurifyItem(ItemStack.f_41583_);
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41619_() && !tile.getAdditionalItem().m_41619_()) {
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, tile.getAdditionalItem());
                tile.setAdditionalItem(ItemStack.f_41583_);
                return InteractionResult.SUCCESS;
            }
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)blockPos, (Direction)Direction.UP)) {
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.m_41619_() && tile.getActions().isItemValidForAdditionalSlot(itemStack) && tile.getAdditionalItem().m_41619_()) {
                ItemStack copy = itemStack.m_41777_();
                copy.m_41764_(1);
                tile.setAdditionalItem(copy);
                itemStack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.m_41619_() && tile.getActions().isItemValidForMainSlot(itemStack) && tile.getPurifyItem().m_41619_()) {
                ItemStack copy = itemStack.m_41777_();
                copy.m_41764_(1);
                tile.setPurifyItem(copy);
                itemStack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return INSIDE;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos blockPos) {
        BlockEntityPurifier tile = (BlockEntityPurifier)world.m_7702_(blockPos);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil(15.0f * output);
    }

    public void m_6810_(BlockState oldState, Level world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!world.m_5776_() && oldState.m_60734_() != newState.m_60734_()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityPurifier.class).ifPresent(tile -> InventoryHelpers.dropItems((Level)world, (Container)tile.getInventory(), (BlockPos)blockPos));
        }
        super.m_6810_(oldState, world, blockPos, newState, isMoving);
    }

    @Override
    public int getDefaultCapacity() {
        return 3000;
    }

    @Override
    public boolean isActivatable() {
        return false;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, Level world, Player player) {
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, Level world) {
        return false;
    }
}

