/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.purifier;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.block.BlockPurifierConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;

public class CollectPotionPurifyAction
implements IPurifierAction {
    public static final Item ALLOWED_ITEM = Items.f_42590_;
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_41720_() == ALLOWED_ITEM;
    }

    @Override
    public boolean canWork(BlockEntityPurifier tile) {
        if (tile.getPurifyItem().m_41619_() && !tile.getAdditionalItem().m_41619_() && tile.getAdditionalItem().m_41720_() == ALLOWED_ITEM && tile.getBucketsFloored() == tile.getMaxBuckets()) {
            List entities = tile.m_58904_().m_45976_(LivingEntity.class, new AABB(tile.m_58899_(), tile.m_58899_().m_7918_(1, 2, 1)));
            for (LivingEntity entity : entities) {
                for (MobEffectInstance potionEffect : entity.m_21220_()) {
                    if (potionEffect.m_19571_()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean work(BlockEntityPurifier tile) {
        Level world = tile.m_58904_();
        int tick = tile.getTick();
        if (tile.getPurifyItem().m_41619_() && !tile.getAdditionalItem().m_41619_() && tile.getAdditionalItem().m_41720_() == ALLOWED_ITEM && tile.getBucketsFloored() == tile.getMaxBuckets()) {
            List entities = tile.m_58904_().m_45976_(LivingEntity.class, new AABB(tile.m_58899_(), tile.m_58899_().m_7918_(1, 2, 1)));
            for (LivingEntity entity : entities) {
                if (entity.m_21220_().isEmpty()) continue;
                if (tick >= 60 && !world.m_5776_()) {
                    for (MobEffectInstance potionEffect : entity.m_21220_()) {
                        if (potionEffect.m_19571_()) continue;
                        entity.m_21195_(potionEffect.m_19544_());
                        if (BlockPurifierConfig.maxPotionEffectDuration > 0 && potionEffect.m_19557_() > BlockPurifierConfig.maxPotionEffectDuration) {
                            int remainingDuration = potionEffect.m_19557_() - BlockPurifierConfig.maxPotionEffectDuration;
                            MobEffectInstance remainingEffect = new MobEffectInstance(potionEffect);
                            remainingEffect.f_19503_ = remainingDuration;
                            entity.m_7292_(remainingEffect);
                            potionEffect.f_19503_ = BlockPurifierConfig.maxPotionEffectDuration;
                        }
                        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42589_);
                        CompoundTag tag = new CompoundTag();
                        ListTag tagList = new ListTag();
                        CompoundTag potionTag = new CompoundTag();
                        itemStack.m_41751_(tag);
                        potionEffect.m_19555_(potionTag);
                        tagList.add((Object)potionTag);
                        tag.m_128365_("CustomPotionEffects", (Tag)tagList);
                        tile.setBuckets(0, 0);
                        tile.setAdditionalItem(itemStack);
                        return true;
                    }
                }
                if (!world.m_5776_()) continue;
                tile.showEffect();
            }
        }
        return false;
    }
}

