/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.purifier;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.block.BlockPurifierConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;
import org.cyclops.evilcraft.core.algorithm.Wrapper;

public class DisenchantPurifyAction
implements IPurifierAction {
    public static final Wrapper<Item> ALLOWED_BOOK = new Wrapper();
    private static final int PURIFY_DURATION = 60;

    protected boolean isAllowed(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        for (String name : BlockPurifierConfig.disenchantBlacklist) {
            if (!ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString().matches(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return this.isAllowed(itemStack);
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_41720_() == ALLOWED_BOOK.get();
    }

    @Override
    public boolean canWork(BlockEntityPurifier tile) {
        if (tile.getBucketsFloored() == tile.getMaxBuckets() && !tile.getPurifyItem().m_41619_() && !tile.getAdditionalItem().m_41619_() && tile.getAdditionalItem().m_41720_() == ALLOWED_BOOK.get()) {
            return this.isAllowed(tile.getPurifyItem()) && !EnchantmentHelper.m_44831_((ItemStack)tile.getPurifyItem()).isEmpty();
        }
        return false;
    }

    @Override
    public boolean work(BlockEntityPurifier tile) {
        boolean done = false;
        ItemStack purifyItem = tile.getPurifyItem().m_41777_();
        Level world = tile.m_58904_();
        int tick = tile.getTick();
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)purifyItem);
        if (!enchantments.isEmpty()) {
            if (tick >= 60) {
                if (!world.m_5776_()) {
                    Enchantment enchantment = this.getRandomEnchantment(world, enchantments);
                    this.setResultingEnchantmentBook(tile, enchantments, enchantment);
                    this.removePriorWorkPenalty(enchantments, purifyItem);
                    purifyItem = this.setRemainingEnchantmentsOnPurifiedItem(enchantments, enchantment, purifyItem);
                    tile.setPurifyItem(purifyItem);
                }
                tile.setBuckets(0, tile.getBucketsRest());
                done = true;
            }
            if (world.m_5776_()) {
                tile.showEffect();
                tile.showEnchantingEffect();
            }
        }
        return done;
    }

    private Enchantment getRandomEnchantment(Level world, Map<Enchantment, Integer> enchantments) {
        int enchantmentIndex = world.f_46441_.m_188503_(enchantments.size());
        return (Enchantment)Lists.newArrayList(enchantments.keySet()).get(enchantmentIndex);
    }

    private void setResultingEnchantmentBook(BlockEntityPurifier tile, Map<Enchantment, Integer> enchantments, Enchantment enchantment) {
        tile.setAdditionalItem(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, enchantments.get(enchantment).intValue())));
    }

    private void removePriorWorkPenalty(Map<Enchantment, Integer> enchantments, ItemStack purifyItem) {
        int penalty = purifyItem.m_41610_();
        int remainingPenalty = penalty - penalty / enchantments.size();
        purifyItem.m_41742_(remainingPenalty);
    }

    private ItemStack setRemainingEnchantmentsOnPurifiedItem(Map<Enchantment, Integer> enchantments, Enchantment enchantment, ItemStack purifyItem) {
        HashMap remainingEnchantments = Maps.newHashMap(enchantments);
        remainingEnchantments.remove(enchantment);
        if (remainingEnchantments.isEmpty() && purifyItem.m_41720_() == Items.f_42690_) {
            purifyItem = new ItemStack((ItemLike)Items.f_42517_);
        }
        if (purifyItem.m_41782_() && purifyItem.m_41783_().m_128441_("StoredEnchantments")) {
            purifyItem.m_41783_().m_128473_("StoredEnchantments");
        }
        EnchantmentHelper.m_44865_((Map)remainingEnchantments, (ItemStack)purifyItem);
        return purifyItem;
    }
}

