/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.broom;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class BroomPartBase
implements IBroomPart {
    private final ResourceLocation id;
    private final IBroomPart.BroomPartType type;
    private final float length;
    private final Rarity rarity;
    private final boolean effect;

    public BroomPartBase(ResourceLocation id, IBroomPart.BroomPartType type, float length) {
        this(id, type, length, Rarity.COMMON, false);
    }

    public BroomPartBase(ResourceLocation id, IBroomPart.BroomPartType type, float length, Rarity rarity, boolean effect) {
        this.id = id;
        this.type = type;
        this.length = length;
        this.rarity = rarity;
        this.effect = effect;
        if (MinecraftHelpers.isClientSide()) {
            this.registerModelResourceLocation();
        }
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void registerModelResourceLocation() {
        BroomParts.REGISTRY.registerPartModel(this, new ResourceLocation(this.getId().m_135827_(), "broom_part/" + this.getId().m_135815_().toLowerCase(Locale.ROOT)));
    }

    @Override
    public String getTranslationKey() {
        return "broom.parts." + this.getId().m_135827_() + "." + this.getId().m_135815_();
    }

    @Override
    @Nullable
    public Component getTooltipLine(String prefix) {
        return Component.m_237113_((String)prefix).m_7220_((Component)Component.m_237115_((String)this.getTranslationKey()));
    }

    @Override
    public boolean shouldAutoRegisterMissingItem() {
        return true;
    }

    @Override
    public int getModelColor() {
        return Helpers.RGBAToInt((int)255, (int)255, (int)255, (int)255);
    }

    @Override
    public IBroomPart.BroomPartType getType() {
        return this.type;
    }

    @Override
    public float getLength() {
        return this.length;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public boolean isEffect() {
        return this.effect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BroomPartBase)) {
            return false;
        }
        BroomPartBase other = (BroomPartBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getLength(), other.getLength()) != 0) {
            return false;
        }
        if (this.isEffect() != other.isEffect()) {
            return false;
        }
        ResourceLocation this$id = this.getId();
        ResourceLocation other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        IBroomPart.BroomPartType this$type = this.getType();
        IBroomPart.BroomPartType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Rarity this$rarity = this.getRarity();
        Rarity other$rarity = other.getRarity();
        return !(this$rarity == null ? other$rarity != null : !this$rarity.equals(other$rarity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BroomPartBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getLength());
        result = result * 59 + (this.isEffect() ? 79 : 97);
        ResourceLocation $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        IBroomPart.BroomPartType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Rarity $rarity = this.getRarity();
        result = result * 59 + ($rarity == null ? 43 : $rarity.hashCode());
        return result;
    }

    public String toString() {
        return "BroomPartBase(id=" + String.valueOf(this.getId()) + ", type=" + String.valueOf(this.getType()) + ", length=" + this.getLength() + ", rarity=" + String.valueOf(this.getRarity()) + ", effect=" + this.isEffect() + ")";
    }
}

