/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.item.EntityItemDefinedRotation;
import org.cyclops.evilcraft.world.gen.structure.WorldStructureDarkTempleConfig;

public class EntityItemDarkStick
extends EntityItemDefinedRotation {
    private static final EntityDataAccessor<Integer> WATCHERID_VALID = SynchedEntityData.m_135353_(EntityItemDarkStick.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> WATCHERID_ANGLE = SynchedEntityData.m_135353_(EntityItemDarkStick.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private double lastPosX = -1.0;
    private double lastPosY = -1.0;
    private double lastPosZ = -1.0;

    public EntityItemDarkStick(EntityType<? extends EntityItemDarkStick> type, Level world) {
        super((EntityType<? extends EntityItemDefinedRotation>)type, world);
    }

    public EntityItemDarkStick(Level world, ItemEntity original) {
        super((EntityType<? extends EntityItemDefinedRotation>)RegistryEntries.ENTITY_ITEM_DARK_STICK, world, original);
    }

    public void m_8097_() {
        super.m_8097_();
        Float angle = MinecraftHelpers.isClientSide() ? null : this.loadRotation();
        this.f_19804_.m_135372_(WATCHERID_VALID, (Object)(angle != null ? 1 : 0));
        this.f_19804_.m_135372_(WATCHERID_ANGLE, (Object)Float.valueOf(angle == null ? 0.0f : angle.floatValue()));
    }

    protected boolean hasMoved() {
        boolean moved = Math.abs(this.lastPosX - this.m_20185_()) > (double)0.1f || Math.abs(this.lastPosZ - this.m_20189_()) > (double)0.1f;
        this.lastPosX = this.m_20185_();
        this.lastPosY = this.m_20186_();
        this.lastPosZ = this.m_20189_();
        return moved;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20193_().m_5776_() && this.hasMoved()) {
            Float angle = this.loadRotation();
            this.setValid(angle != null);
            this.setAngle(angle == null ? 0.0f : angle.floatValue());
        }
    }

    @Nullable
    private Float loadRotation() {
        Registry registry = this.m_9236_().m_9598_().m_175515_(Registries.f_256944_);
        HolderSet holderset = (HolderSet)registry.m_203636_(WorldStructureDarkTempleConfig.KEY).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})).orElseThrow();
        Pair closestHolder = ((ServerLevel)this.m_9236_()).m_7726_().m_8481_().m_223037_((ServerLevel)this.m_9236_(), holderset, BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), 100, false);
        if (closestHolder != null) {
            BlockPos closest = new BlockPos(((BlockPos)closestHolder.getFirst()).m_123341_(), 0, ((BlockPos)closestHolder.getFirst()).m_123343_());
            double d = closest.m_123331_((Vec3i)new BlockPos((int)this.m_20185_(), 0, (int)this.m_20189_()));
            if (d <= 256.0) {
                return null;
            }
            BlockPos normalized = new BlockPos(closest.m_123341_() - (int)this.m_20185_(), 0, closest.m_123343_() - (int)this.m_20189_());
            return Float.valueOf((float)(Math.atan2(normalized.m_123341_(), normalized.m_123343_()) * 180.0 / Math.PI));
        }
        return null;
    }

    @Override
    protected boolean hasCustomRotation() {
        return this.isValid();
    }

    public float getAngle() {
        return ((Float)this.f_19804_.m_135370_(WATCHERID_ANGLE)).floatValue();
    }

    protected void setAngle(float angle) {
        this.f_19804_.m_135381_(WATCHERID_ANGLE, (Object)Float.valueOf(angle));
    }

    public boolean isValid() {
        return (Integer)this.f_19804_.m_135370_(WATCHERID_VALID) == 1;
    }

    protected void setValid(boolean valid) {
        this.f_19804_.m_135381_(WATCHERID_VALID, (Object)(valid ? 1 : 0));
    }
}

