/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityWerewolf;
import org.cyclops.evilcraft.entity.villager.VillagerProfessionWerewolfConfig;
import org.cyclops.evilcraft.item.IItemEmpowerable;

public class EntityStruckByLightningEventHook {
    private LightningBolt lastLightningBolt;
    private Set<Integer> affectedVillagers;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        this.empowerItem(event);
        this.transformVillager(event);
    }

    private void empowerItem(EntityStruckByLightningEvent event) {
        IItemEmpowerable empowerable;
        ItemEntity entity;
        if (event.getEntity() instanceof ItemEntity && (entity = (ItemEntity)event.getEntity()).m_32055_().m_41720_() instanceof IItemEmpowerable && !(empowerable = (IItemEmpowerable)entity.m_32055_().m_41720_()).isEmpowered(entity.m_32055_())) {
            entity.m_32045_(empowerable.empower(entity.m_32055_()));
            event.setCanceled(true);
            event.getLightning().m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void transformVillager(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof Villager && VillagerProfessionWerewolfConfig.convertOnLightning) {
            Villager entity = (Villager)event.getEntity();
            if (this.lastLightningBolt != event.getLightning()) {
                this.lastLightningBolt = event.getLightning();
                this.affectedVillagers = new HashSet<Integer>();
            }
            if (!this.affectedVillagers.add(entity.m_19879_())) {
                event.setCanceled(true);
                return;
            }
            if (entity.m_9236_().f_46441_.m_188499_()) {
                event.setCanceled(false);
                return;
            }
            if (entity.m_7141_().m_35571_() != RegistryEntries.VILLAGER_PROFESSION_WEREWOLF) {
                event.setCanceled(true);
                EntityWerewolf.initializeWerewolfVillagerData(entity);
            }
        }
    }
}

