/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;

public class ItemEffortlessRing
extends Item {
    private static final int TICK_MODULUS = 1;
    private static final float SPEED_BONUS = 0.05f;
    private static final AttributeModifier STEP_SIZE_MODIFIER = new AttributeModifier("evilcraft:stepHeightModifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final float JUMP_DISTANCE_FACTOR = 0.05f;
    private static final float JUMP_HEIGHT_FACTOR = 0.3f;
    private static final float FALLDISTANCE_REDUCTION = 2.0f;

    public ItemEffortlessRing(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerFall);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerJump);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerUpdate);
    }

    public void adjustParameters(ItemStack itemStack, Player player) {
        AttributeInstance attribute;
        if (player.f_20902_ > 0.0f && player.m_20096_()) {
            player.m_19920_(player.m_20069_() ? 0.016666668f : 0.05f, new Vec3(0.0, 0.0, 1.0));
        }
        if ((attribute = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get())) != null && !attribute.m_22109_(STEP_SIZE_MODIFIER)) {
            attribute.m_22118_(STEP_SIZE_MODIFIER);
        }
    }

    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && ItemStackHelpers.hasPlayerItem((Player)(player = (Player)event.getEntity()), (Item)this)) {
            player.m_20256_(player.m_20184_().m_82520_(0.0, (double)0.3f, 0.0));
        }
    }

    public void onPlayerUpdate(LivingEvent.LivingTickEvent event) {
        Player player;
        AttributeInstance attribute;
        if (event.getEntity() instanceof Player && (attribute = (player = (Player)event.getEntity()).m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get())) != null && attribute.m_22109_(STEP_SIZE_MODIFIER) && !ItemStackHelpers.hasPlayerItem((Player)player, (Item)this)) {
            attribute.m_22130_(STEP_SIZE_MODIFIER);
        }
    }

    public void onPlayerFall(LivingFallEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && ItemStackHelpers.hasPlayerItem((Player)(player = (Player)event.getEntity()), (Item)this)) {
            event.setDistance(event.getDistance() - 2.0f);
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            this.adjustParameters(stack, (Player)entityIn);
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }
}

