/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.ai.navigator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_8;
import net.minecraft.class_9;
import org.jetbrains.annotations.NotNull;

public class BonusPathFinder
extends class_13 {
    public BonusPathFinder(class_8 processor, int maxVisitedNodes) {
        super(processor, maxVisitedNodes);
    }

    public class_11 method_52(@NotNull class_1950 region, @NotNull class_1308 mob, @NotNull Set<class_2338> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        class_11 path = super.method_52(region, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier);
        return path == null ? null : new CachedPath(path);
    }

    static class CachedPath
    extends class_11 {
        private final Cache<Integer, class_243> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(5L, TimeUnit.SECONDS).build();

        public CachedPath(class_11 original) {
            super(CachedPath.copyNodes(original), original.method_48(), original.method_21655());
        }

        @NotNull
        public class_243 method_47(@NotNull class_1297 entity, int index) {
            try {
                return (class_243)this.cache.get((Object)index, () -> this.computeEntityPosAtNode(entity, index));
            }
            catch (Exception e) {
                return this.computeEntityPosAtNode(entity, index);
            }
        }

        private class_243 computeEntityPosAtNode(class_1297 entity, int index) {
            class_9 point = this.method_40(index);
            double offsetX = (double)class_3532.method_15375((float)(entity.method_17681() + 1.0f)) * 0.5;
            double x = (double)point.field_40 + offsetX;
            double y = point.field_39;
            double z = (double)point.field_38 + offsetX;
            return new class_243(x, y, z);
        }

        private static List<class_9> copyNodes(class_11 original) {
            return (List)IntStream.range(0, original.method_38()).mapToObj(arg_0 -> ((class_11)original).method_40(arg_0)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        }
    }
}

