/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import com.google.common.collect.Sets;
import dev.xylonity.knightquest.common.entity.entities.AbstractSwampmanAxeEntity;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestEntities;
import java.util.Set;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3966;
import net.minecraft.class_9381;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SwampmanAxeEntity
extends AbstractSwampmanAxeEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> ID_EFFECT_COLOR = class_2945.method_12791(SwampmanAxeEntity.class, (class_2941)class_2943.field_13327);
    private final Set<class_1293> effects = Sets.newHashSet();

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public SwampmanAxeEntity(class_1299<? extends AbstractSwampmanAxeEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    public SwampmanAxeEntity(class_1937 pLevel, class_1309 pShooter) {
        super(KnightQuestEntities.SWAMPMAN_AXE.get(), pShooter, pLevel);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ID_EFFECT_COLOR, (Object)-1);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && !this.effects.isEmpty() && this.inGroundTime >= 600) {
            this.method_37908().method_8421((class_1297)this, (byte)0);
            this.effects.clear();
            this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    private void makeParticle(int pParticleAmount) {
        int i = this.getColor();
        if (i != -1 && pParticleAmount > 0) {
            for (int j = 0; j < pParticleAmount; ++j) {
                this.method_37908().method_8406((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)i), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(ID_EFFECT_COLOR);
    }

    @Override
    protected void doPostHurtEffects(class_1309 pLiving) {
        super.doPostHurtEffects(pLiving);
        class_1297 entity = this.method_37225();
        if (!this.effects.isEmpty()) {
            for (class_1293 mobeffectinstance : this.effects) {
                pLiving.method_37222(mobeffectinstance, entity);
            }
        }
    }

    @Override
    protected void method_7454(class_3966 pResult) {
        super.method_7454(pResult);
        class_1297 entity = pResult.method_17782();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (KQConfigValues.POISON_PHASE_2_SWAMPMAN.get().booleanValue()) {
                livingEntity.method_6092(new class_1293(class_1294.field_5899, 100, 0, true, true, true));
            }
        }
    }

    public void method_5711(byte pId) {
        if (pId == 0) {
            int i = this.getColor();
            if (i != -1) {
                float d0 = (float)(i >> 16 & 0xFF) / 255.0f;
                float d1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float d2 = (float)(i & 0xFF) / 255.0f;
                for (int j = 0; j < 20; ++j) {
                    this.method_37908().method_8406((class_2394)class_9381.method_58255((class_2396)class_2398.field_11226, (float)d0, (float)d1, (float)d2), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), (double)d0, (double)d1, (double)d2);
                }
            }
        } else {
            super.method_5711(pId);
        }
    }
}

