/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api;

import dev.xylonity.knightlib.mixin.CameraAccessor;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public final class CameraShakeManager {
    private static final Map<UUID, Shake> SHAKES = new ConcurrentHashMap<UUID, Shake>();

    private CameraShakeManager() {
    }

    public static void shake(Player player, int durationTicks, float intensityX, float intensityY, float intensityZ, int fadeStartTick) {
        SHAKES.put(player.m_20148_(), new Shake(Util.m_137550_(), player.m_9236_(), durationTicks, intensityX, intensityY, intensityZ, fadeStartTick));
    }

    public static void applyShakeIfPresent(Player player, Camera camera) {
        Shake shake = SHAKES.get(player.m_20148_());
        if (shake == null) {
            return;
        }
        if (shake.isExpired()) {
            SHAKES.remove(player.m_20148_());
            return;
        }
        shake.apply(camera);
    }

    public static void clear() {
        SHAKES.values().removeIf(Shake::isExpired);
    }

    private record Shake(long startMillis, Level lvl, int durationTicks, float ix, float iy, float iz, int fadeStart) {
        void apply(Camera camera) {
            int elapsed = (int)((Util.m_137550_() - this.startMillis) / 50L);
            float fade = 1.0f;
            if (this.fadeStart >= 0 && elapsed >= this.fadeStart) {
                fade = 1.0f - Math.min(1.0f, (float)(elapsed - this.fadeStart) / (float)(this.durationTicks - this.fadeStart));
            }
            double x = (this.lvl.f_46441_.m_188500_() - 0.5) * (double)this.ix * (double)fade;
            double y = (this.lvl.f_46441_.m_188500_() - 0.5) * (double)this.iy * (double)fade;
            double z = (this.lvl.f_46441_.m_188500_() - 0.5) * (double)this.iz * (double)fade;
            ((CameraAccessor)camera).moveAccessor(x, y, z);
        }

        boolean isExpired() {
            return (Util.m_137550_() - this.startMillis) / 50L >= (long)this.durationTicks;
        }
    }
}

