/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.item;

import dev.xylonity.knightlib.api.IGreatChaliceInteractable;
import dev.xylonity.knightlib.api.impl.GreatChaliceState;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import dev.xylonity.knightlib.registry.KnightLibItems;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyGrailItem
extends Item
implements IGreatChaliceInteractable {
    public EmptyGrailItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getChargesToApply() {
        return -12;
    }

    @Override
    public boolean canInteract(GreatChaliceBlockEntity chalice, Level level, Player player) {
        return chalice.isFull() && chalice.getState() == GreatChaliceState.NORMAL;
    }

    @Override
    @NotNull
    public Set<ItemStack> getRewards() {
        return Set.of(new ItemStack((ItemLike)KnightLibItems.FILLED_GRAIL.get()));
    }

    @Override
    @NotNull
    public Set<SoundEvent> getInteractionSounds() {
        return Set.of(SoundEvents.f_11772_);
    }

    @Override
    public void onPostInteraction(GreatChaliceBlockEntity chalice, Player player, Level level, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            RandomSource rand = sv.m_213780_();
            for (int i = 0; i < 25; ++i) {
                double r = 0.7 * Math.sqrt(rand.m_188500_());
                double t = rand.m_188500_() * Math.PI * 2.0;
                double px = (double)chalice.m_58899_().m_123341_() + 0.5 + r * Math.cos(t);
                double pz = (double)chalice.m_58899_().m_123343_() + 0.5 + r * Math.sin(t);
                double py = (double)chalice.m_58899_().m_123342_() + 1.0 + rand.m_188500_() * 0.3;
                sv.m_8767_((ParticleOptions)ParticleTypes.f_123806_, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag flag) {
        super.m_7373_(itemStack, level, list, flag);
        list.add((Component)Component.m_237115_((String)"tooltip.item.knightlib.empty_grail"));
    }
}

