/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.common.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public abstract class AbstractRibbonTrailParticle
extends Particle {
    protected static final int MAX_TRAIL_POINTS = 64;
    protected final Vec3[] positionBuffer = new Vec3[64];
    protected int bufferIdx = -1;
    public float r;
    public float g;
    public float b;
    protected float ribbonAlpha = 1.0f;

    public AbstractRibbonTrailParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, float r, float g, float b) {
        super(level, x, y, z);
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.r = r;
        this.g = g;
        this.b = b;
        Arrays.fill(this.positionBuffer, new Vec3(x, y, z));
    }

    public void m_5989_() {
        this.savePosInBuffer();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.f_107215_ *= 0.99;
        this.f_107216_ *= 0.99;
        this.f_107217_ *= 0.99;
        this.f_107216_ -= (double)this.f_107226_;
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    protected void savePosInBuffer() {
        Vec3 current = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        if (this.bufferIdx == -1) {
            Arrays.fill(this.positionBuffer, current);
        }
        if (++this.bufferIdx >= 64) {
            this.bufferIdx = 0;
        }
        this.positionBuffer[this.bufferIdx] = current;
    }

    public void m_5744_(@NotNull VertexConsumer ignored, @NotNull Camera camera, float partialTicks) {
        if (this.bufferIdx < 0) {
            return;
        }
        MultiBufferSource.BufferSource buff = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vertexConsumer = buff.m_6299_(RenderType.m_110473_((ResourceLocation)this.getRibbonSprite()));
        PoseStack mPose = new PoseStack();
        mPose.m_85836_();
        mPose.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
        Vec3 from = new Vec3(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_), Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_), Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_));
        float yaw = (float)(-Math.PI) / 180 * camera.m_90590_();
        Vec3 topOffset = new Vec3(0.0, (double)(this.getRibbonHeight() / 2.0f), 0.0).m_82524_(yaw);
        Vec3 botOffset = new Vec3(0.0, (double)(-this.getRibbonHeight() / 2.0f), 0.0).m_82524_(yaw);
        int segments = this.totalSegments();
        for (int i = 0; i < segments; ++i) {
            Vec3 samplex = this.sampleTrailPoint(i * this.segmentInterval(), partialTicks);
            float u1 = (float)i / (float)segments;
            float u2 = (float)(i + 1) / (float)segments;
            PoseStack.Pose pose = mPose.m_85850_();
            Matrix4f mat = pose.m_252922_();
            Matrix3f norm = pose.m_252943_();
            vertexConsumer.m_252986_(mat, (float)from.f_82479_ + (float)botOffset.f_82479_, (float)from.f_82480_ + (float)botOffset.f_82480_, (float)from.f_82481_ + (float)botOffset.f_82481_).m_85950_(this.r, this.g, this.b, this.ribbonAlpha).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(this.m_6355_(partialTicks)).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(mat, (float)samplex.f_82479_ + (float)botOffset.f_82479_, (float)samplex.f_82480_ + (float)botOffset.f_82480_, (float)samplex.f_82481_ + (float)botOffset.f_82481_).m_85950_(this.r, this.g, this.b, this.ribbonAlpha).m_7421_(u2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(this.m_6355_(partialTicks)).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(mat, (float)samplex.f_82479_ + (float)topOffset.f_82479_, (float)samplex.f_82480_ + (float)topOffset.f_82480_, (float)samplex.f_82481_ + (float)topOffset.f_82481_).m_85950_(this.r, this.g, this.b, this.ribbonAlpha).m_7421_(u2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(this.m_6355_(partialTicks)).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(mat, (float)from.f_82479_ + (float)topOffset.f_82479_, (float)from.f_82480_ + (float)topOffset.f_82480_, (float)from.f_82481_ + (float)topOffset.f_82481_).m_85950_(this.r, this.g, this.b, this.ribbonAlpha).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(this.m_6355_(partialTicks)).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            from = samplex;
        }
        mPose.m_85849_();
        buff.m_109911_();
    }

    protected Vec3 sampleTrailPoint(int idx, float tick) {
        Vec3 position = this.positionBuffer[this.bufferIdx - idx - 1 & 0x3F];
        Vec3 subtract = this.positionBuffer[this.bufferIdx - idx & 0x3F].m_82546_(position);
        return position.m_82549_(subtract.m_82490_((double)tick));
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    protected int totalSegments() {
        return 20;
    }

    protected int segmentInterval() {
        return 1;
    }

    protected abstract float getRibbonHeight();

    protected abstract ResourceLocation getRibbonSprite();
}

