/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.config;

import dev.xylonity.knightlib.config.api.AutoConfig;
import dev.xylonity.knightlib.config.api.ConfigEntry;
import dev.xylonity.knightlib.config.api.DecorationType;
import dev.xylonity.knightlib.config.impl.ConfigManager;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public final class ConfigComposer {
    private static final Map<Field, ForgeConfigSpec.ConfigValue<?>> VALUES = new ConcurrentHashMap();

    public static void registerConfig(Class<?> clazz, IEventBus modBus) {
        ConfigComposer.registerConfig(clazz, modBus, ModConfig.Type.COMMON);
    }

    public static void registerConfig(Class<?> clazz, IEventBus modBus, ModConfig.Type type) {
        AutoConfig ac = clazz.getAnnotation(AutoConfig.class);
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        ConfigComposer.makeConfig(builder, clazz, ac.style(), ac.categoryBanner());
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)builder.build(), ConfigComposer.specName(clazz));
        ConfigManager.init(FMLPaths.CONFIGDIR.get(), clazz);
        modBus.addListener(e -> ConfigComposer.applyFromSpec());
        modBus.addListener(e -> {
            ConfigComposer.applyFromSpec();
            ConfigManager.init(FMLPaths.CONFIGDIR.get(), clazz);
        });
    }

    private static String specName(Class<?> clazz) {
        return clazz.getAnnotation(AutoConfig.class).file() + ".toml";
    }

    private static void makeConfig(ForgeConfigSpec.Builder b, Class<?> clazz, DecorationType style, boolean categoryBanner) {
        Map<String, List<Field>> byCategory = Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.isAnnotationPresent(ConfigEntry.class)).collect(Collectors.groupingBy(f -> f.getAnnotation(ConfigEntry.class).category()));
        for (Map.Entry<String, List<Field>> catEntry : byCategory.entrySet()) {
            String category = catEntry.getKey();
            if (!category.isEmpty()) {
                if (categoryBanner) {
                    String[] bannerLines = ConfigManager.buildCategoryBanner(category, style).split("\n");
                    b.comment(bannerLines);
                }
                b.push(category);
            }
            for (Field field : catEntry.getValue()) {
                Object defaultVal;
                ConfigEntry meta = field.getAnnotation(ConfigEntry.class);
                field.setAccessible(true);
                try {
                    defaultVal = field.get(null);
                }
                catch (IllegalAccessException e) {
                    defaultVal = null;
                }
                String rawComment = ConfigManager.buildEntryComment(meta, defaultVal, style);
                String wrapped = ConfigManager.wrapText(rawComment);
                b.comment(wrapped.split("\n"));
                ForgeConfigSpec.ConfigValue<?> cfgValue = ConfigComposer.defineValue(b, field, meta);
                VALUES.put(field, cfgValue);
            }
            if (category.isEmpty()) continue;
            b.pop();
        }
    }

    private static ForgeConfigSpec.ConfigValue<?> defineValue(ForgeConfigSpec.Builder b, Field field, ConfigEntry entry) {
        try {
            String name = field.getName();
            Class<?> type = field.getType();
            Predicate<Object> inIntRange = v -> {
                Integer i;
                return v instanceof Integer && (double)(i = (Integer)v).intValue() >= entry.min() && (double)i.intValue() <= entry.max();
            };
            Predicate<Object> inLongRange = v -> {
                Long l;
                return v instanceof Long && (l = (Long)v) >= (long)entry.min() && l <= (long)entry.max();
            };
            Predicate<Object> inFloatRange = v -> {
                Float f;
                return v instanceof Float && (f = (Float)v).floatValue() >= (float)entry.min() && f.floatValue() <= (float)entry.max();
            };
            Predicate<Object> inDoubleRange = v -> {
                Double d;
                return v instanceof Double && (d = (Double)v) >= entry.min() && d <= entry.max();
            };
            if (type == Integer.TYPE) {
                return b.define(name, (Object)field.getInt(null), inIntRange);
            }
            if (type == Double.TYPE) {
                return b.define(name, (Object)field.getDouble(null), inDoubleRange);
            }
            if (type == Float.TYPE) {
                return b.define(name, (Object)Float.valueOf(field.getFloat(null)), inFloatRange);
            }
            if (type == Long.TYPE) {
                return b.define(name, (Object)field.getLong(null), inLongRange);
            }
            if (type == Boolean.TYPE) {
                return b.define(name, field.getBoolean(null));
            }
            return b.define(name, field.get(null));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void applyFromSpec() {
        VALUES.forEach((field, value) -> {
            try {
                field.set(null, value.get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

