/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.config.impl;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import dev.xylonity.knightlib.KnightLibCommon;
import dev.xylonity.knightlib.config.api.AutoConfig;
import dev.xylonity.knightlib.config.api.ConfigEntry;
import dev.xylonity.knightlib.config.api.DecorationType;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConfigManager {
    private static Path CONFIG_DIR = Path.of("config", new String[0]);
    private static final Set<Class<?>> REGISTERED = new HashSet();

    public static void init(Path configDir, Class<?> ... configs) {
        CONFIG_DIR = configDir;
        for (Class<?> clazz : configs) {
            ConfigManager.loadOrCreate(clazz);
        }
    }

    private static void loadOrCreate(Class<?> clazz) {
        if (!REGISTERED.add(clazz)) {
            return;
        }
        AutoConfig meta = clazz.getAnnotation(AutoConfig.class);
        if (meta == null) {
            return;
        }
        DecorationType style = meta.style();
        String fileName = meta.file() + ".toml";
        Path tomlPath = CONFIG_DIR.resolve(fileName);
        CommentedFileConfig cfg = (CommentedFileConfig)CommentedFileConfig.builder((Path)tomlPath, (ConfigFormat)TomlFormat.instance()).autosave().preserveInsertionOrder().sync().build();
        cfg.load();
        HashSet<String> seenCats = new HashSet<String>();
        for (Field field : clazz.getDeclaredFields()) {
            Object def;
            String target;
            ConfigEntry e = field.getAnnotation(ConfigEntry.class);
            if (e == null) continue;
            field.setAccessible(true);
            String category = e.category();
            String entry = field.getName();
            String path = category.isEmpty() ? entry : category + "." + entry;
            String string = target = category.isEmpty() ? entry : category;
            if (seenCats.add(category)) {
                if (meta.categoryBanner()) {
                    cfg.setComment(target, ConfigManager.wrapAndIndent(ConfigManager.buildCategoryBanner(category, style)));
                } else {
                    cfg.setComment(target, "");
                }
            }
            try {
                def = field.get(null);
            }
            catch (Exception exception) {
                continue;
            }
            Object raw = cfg.get(path);
            Object oldDefault = ConfigManager.parseDefFromComment(cfg.getComment(path), field.getType());
            if (!cfg.contains(path) || oldDefault != null && ConfigManager.same(raw, oldDefault)) {
                cfg.set(path, def);
                raw = cfg.get(path);
            }
            String entryComment = ConfigManager.buildEntryComment(e, def, style);
            cfg.setComment(path, ConfigManager.wrapAndIndent(entryComment));
            Object val = ConfigManager.clamp(raw, e, field.getType());
            if (val == null) {
                val = def;
            }
            try {
                ConfigManager.setPrimitive(field, val);
            }
            catch (Exception exception) {
                KnightLibCommon.LOGGER.error("[CONFIG] Couldn't assign {}: {}", (Object)entry, (Object)exception.getMessage());
            }
        }
        cfg.save();
    }

    private static Object parseDefFromComment(String s, Class<?> clazz) {
        if (s == null) {
            return null;
        }
        Matcher m = Pattern.compile("Default:\\s*([^\\|\\n]+)").matcher(s);
        if (!m.find()) {
            return null;
        }
        String raw = m.group(1).trim();
        try {
            return switch (clazz.getName()) {
                case "int" -> Integer.parseInt(raw);
                case "long" -> Long.parseLong(raw);
                case "float" -> Float.valueOf(Float.parseFloat(raw));
                case "double" -> Double.parseDouble(raw);
                case "boolean" -> Boolean.parseBoolean(raw);
                default -> raw;
            };
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean same(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Number) {
            Number n1 = (Number)a;
            if (b instanceof Number) {
                Number n2 = (Number)b;
                return Math.abs(n1.doubleValue() - n2.doubleValue()) < 1.0E-9;
            }
        }
        return a.equals(b);
    }

    public static String buildCategoryBanner(String cat, DecorationType style) {
        String title = (cat.isEmpty() ? "GENERAL" : cat.toUpperCase()) + " SETTINGS";
        return switch (style) {
            case DecorationType.VERBOSE -> {
                String line = "=".repeat(70);
                yield String.join((CharSequence)"\n", line, ConfigManager.centerText(title, 70), line);
            }
            case DecorationType.RUSTIC -> ">>>> [" + title + "] <<<<";
            case DecorationType.STARSET -> {
                String line = "=".repeat(70);
                yield String.join((CharSequence)"\n", line, ConfigManager.centerText("\u00ab\u2726\u00bb  " + title + "  \u00ab\u2726\u00bb", 70), line);
            }
            default -> title.toLowerCase().replace(" settings", "") + " \u00a7\u00a7";
        };
    }

    public static String buildEntryComment(ConfigEntry entry, Object defaultRawValue, DecorationType style) {
        String base = entry.comment().trim();
        String note = entry.note().trim();
        boolean isDouble = defaultRawValue instanceof Double;
        String defaultValue = isDouble ? ConfigManager.hasDecimals(((Number)defaultRawValue).doubleValue(), true) : defaultRawValue.toString();
        String minValue = ConfigManager.hasDecimals(entry.min(), isDouble);
        String maxValue = ConfigManager.hasDecimals(entry.max(), isDouble);
        boolean showRange = !(defaultRawValue instanceof Boolean);
        switch (style) {
            case VERBOSE: {
                String border = "-".repeat(64);
                StringBuilder sb = new StringBuilder(border);
                sb.append("\n").append(base).append("\n");
                if (!note.isEmpty()) {
                    sb.append("\nNote: ").append(note).append("\n");
                }
                sb.append("\n- Default: ").append(defaultValue);
                if (showRange) {
                    sb.append("\n").append("- Range: " + minValue + " ~ " + maxValue);
                }
                sb.append("\n").append(border);
                return sb.toString();
            }
            case RUSTIC: {
                StringBuilder sb = new StringBuilder();
                sb.append("$> ").append(base).append("\n").append("$> Default: ").append(defaultValue);
                if (showRange) {
                    sb.append(" | Min: " + minValue + " ~ Max: " + maxValue);
                }
                if (!note.isEmpty()) {
                    sb.append("\n$> Note: ").append(note);
                }
                return sb.toString();
            }
            case STARSET: {
                StringBuilder b = new StringBuilder();
                b.append("\u2726 ").append(base).append("\n").append("\u2726 Default: ").append(defaultValue);
                if (showRange) {
                    b.append(" | Range: ").append(minValue).append(" -~- ").append(maxValue);
                }
                if (!note.isEmpty()) {
                    b.append("\n\u2726 Note: ").append(note);
                }
                return b.toString();
            }
        }
        StringBuilder b = new StringBuilder(base).append("\n\nDefault: ").append(defaultValue);
        if (showRange) {
            b.append("\nRange: ").append(minValue).append(" ~ ").append(maxValue);
        }
        if (!note.isEmpty()) {
            b.append("\n\nNote: ").append(note);
        }
        return b.toString();
    }

    private static String hasDecimals(double d, boolean forceDecimal) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return Double.toString(d);
        }
        long asLong = (long)d;
        if (d == (double)asLong) {
            return forceDecimal ? asLong + ".0" : Long.toString(asLong);
        }
        return Double.toString(d);
    }

    public static String wrapText(String text) {
        StringBuilder out = new StringBuilder();
        for (String paragraph : text.split("\n")) {
            String[] words = paragraph.split(" ");
            int col = 0;
            for (String w : words) {
                if (col + w.length() > 130) {
                    out.append("\n");
                    col = 0;
                } else if (col > 0) {
                    out.append(" ");
                    ++col;
                }
                out.append(w);
                col += w.length();
            }
            out.append("\n");
        }
        return out.toString().trim();
    }

    private static String wrapAndIndent(String comment) {
        String wrapped = ConfigManager.wrapText(comment);
        StringBuilder s = new StringBuilder();
        for (String line : wrapped.split("\n")) {
            s.append(" ").append(line).append("\n");
        }
        return s.substring(0, s.length() - 1);
    }

    private static String centerText(String text, int width) {
        int pad = (width - text.length()) / 2;
        return " ".repeat(Math.max(0, pad)) + text;
    }

    private static Object clamp(Object raw, ConfigEntry e, Class<?> type) {
        if (!(raw instanceof Number)) {
            return raw;
        }
        Number num = (Number)raw;
        double d = Math.max(e.min(), Math.min(e.max(), num.doubleValue()));
        return switch (type.getName()) {
            case "int" -> (int)d;
            case "long" -> (long)d;
            case "float" -> Float.valueOf((float)d);
            case "double" -> d;
            default -> raw;
        };
    }

    private static void setPrimitive(Field f, Object v) throws Exception {
        switch (f.getType().getName()) {
            case "int": {
                f.setInt(null, (Integer)v);
                break;
            }
            case "long": {
                f.setLong(null, (Long)v);
                break;
            }
            case "float": {
                f.setFloat(null, ((Float)v).floatValue());
                break;
            }
            case "double": {
                f.setDouble(null, (Double)v);
                break;
            }
            case "boolean": {
                f.setBoolean(null, (Boolean)v);
                break;
            }
            default: {
                f.set(null, v);
            }
        }
    }
}

