/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.boss;

import dev.xylonity.knightquest.common.ai.navigator.GroundNavigator;
import dev.xylonity.knightquest.common.item.KQFullSetChecker;
import dev.xylonity.knightquest.common.material.KQArmorMaterials;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NethermanCloneEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public NethermanCloneEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, (double)0.1f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22278_, 5.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)0.4f, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_6667_(@NotNull DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        for (Player player : this.m_9236_().m_6907_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                for (int u = 0; u < 30; ++u) {
                    double speed = 0.5 + this.m_217043_().m_188500_() * 0.2;
                    double x = this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * 0.2;
                    double y = this.m_20186_() + (double)this.m_20192_() + (this.m_217043_().m_188500_() - 0.5) * 0.2;
                    double z = this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * 0.2;
                    Vec3 look = this.m_20154_();
                    double vx = look.f_82479_ * speed;
                    double vy = look.f_82480_ * speed;
                    double vz = look.f_82481_ * speed;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_175821_, true, x, y, z, (float)vx, (float)vy, (float)vz, 0.2f, 2));
                }
            }
            if (!(this.m_20270_((Entity)player) <= 3.0f) || KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.POLAR)) continue;
            player.m_146917_(player.m_146888_() + KQConfigValues.CLONE_EXPLOSION_FREEZE_TICKS);
        }
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_144242_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            for (Player player : this.m_9236_().m_6907_()) {
                if (!((double)this.m_20270_((Entity)player) <= 2.0)) continue;
                this.m_6074_();
                break;
            }
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 1 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "coreController", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }
}

