/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.item;

import dev.xylonity.knightlib.api.impl.GreatChaliceState;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import dev.xylonity.knightlib.registry.KnightLibBlocks;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KQWeaponItem
extends SwordItem {
    public KQWeaponItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        CompoundTag tag = stack.m_41784_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GreatChaliceBlockEntity) {
            GreatChaliceBlockEntity be = (GreatChaliceBlockEntity)blockEntity;
            if (!level.f_46443_ && be.isFull() && be.getState() == GreatChaliceState.CHAOTIC) {
                be.setCharges(0);
                level.m_5594_(null, pos, SoundEvents.f_11868_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!tag.m_128471_("Activated")) {
                    tag.m_128379_("Activated", true);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        int cooldownTicks;
        long lastUsed;
        BlockState blockState;
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult blockHit = KQWeaponItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockHit.m_6662_() == HitResult.Type.BLOCK && (blockState = level.m_8055_(blockHit.m_82425_())).m_60713_((Block)KnightLibBlocks.GREAT_CHALICE.get())) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128471_("Activated")) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        long currentTime = level.m_46467_();
        if (currentTime - (lastUsed = tag.m_128454_("LastUsed")) >= (long)(cooldownTicks = this.getCooldownTicks())) {
            this.interaction(level, player, hand);
            if (!level.f_46443_) {
                tag.m_128356_("LastUsed", currentTime);
                player.m_36335_().m_41524_((Item)this, cooldownTicks);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        if (this.isEnabled()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)("tooltip.weapon.knightquest." + this.getName())));
            boolean isActivated = pStack.m_41784_().m_128471_("Activated");
            if (!isActivated) {
                pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.weapon.knightquest.disabled_abilities"));
            }
            pTooltipComponents.add((Component)Component.m_237110_((String)("tooltip.weapon.knightquest." + this.getName() + ".active"), (Object[])new Object[]{Float.valueOf((float)KQConfigValues.SPEED_TICKS_KUKRI / 20.0f), Float.valueOf((float)KQConfigValues.INV_TICKS_PALADIN / 20.0f), (int)Math.floor(KQConfigValues.EXTRA_DAMAGE_UCHIGATANA * 100.0), Float.valueOf((float)KQConfigValues.REFLECTION_TIME_KHOPESH / 20.0f), KQConfigValues.TICKS_CLEAVER / 20}));
            pTooltipComponents.add((Component)Component.m_237110_((String)("tooltip.weapon.knightquest." + this.getName() + ".passive"), (Object[])new Object[]{(int)Math.floor(KQConfigValues.EXTRA_DAMAGE_PASSIVE_UCHIGATANA * 100.0), (int)Math.floor(KQConfigValues.ENEMY_HEALTH_PASSIVE_UCHIGATANA * 100.0), (int)Math.floor(KQConfigValues.CHANCE_BURN_KHOPESH * 100.0), KQConfigValues.REGEN_HP_PALADIN, KQConfigValues.REGEN_TICKS_PALADIN / 20, (int)Math.floor(KQConfigValues.REGEN_MAX_PALADIN * 100.0), (int)Math.floor(KQConfigValues.EXTRA_DAMAGE_PASSIVE_CLEAVER * 100.0), (int)Math.floor(KQConfigValues.ENEMY_HEALTH_PASSIVE_CLEAVER * 100.0)}));
            if (!isActivated) {
                pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.weapon.knightquest.use_chalice"));
            }
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public abstract void interaction(Level var1, Player var2, InteractionHand var3);

    public abstract int getCooldownTicks();

    public abstract String getName();

    protected abstract boolean isEnabled();
}

