/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.api.util;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class KnightLibUtil {
    private KnightLibUtil() {
    }

    public static boolean isEntityBehind(class_1297 from, class_1297 to, double fov) {
        if (from == null || to == null) {
            return false;
        }
        class_243 toTarget = new class_243(to.method_23317(), from.method_23318(), to.method_23321()).method_1020(from.method_19538()).method_1029();
        double angle = Math.acos(from.method_5720().method_1029().method_1026(toTarget)) * 57.29577951308232;
        return angle >= fov / 2.0;
    }

    @Nullable
    public static class_1297 raycastEntity(class_1297 exception, class_1937 level, class_243 start, class_243 end) {
        return KnightLibUtil.raycastEntity(exception, level, start, end, e -> true);
    }

    @Nullable
    public static class_1297 raycastEntity(class_1297 exception, class_1937 level, class_243 start, class_243 end, Predicate<class_1297> predicate) {
        class_3966 hit = class_1675.method_18077((class_1937)level, (class_1297)exception, (class_243)start, (class_243)end, (class_238)new class_238(start, end), predicate);
        if (hit == null) {
            return null;
        }
        return hit.method_17782();
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1297 center, Class<T> entityType, double radius) {
        return KnightLibUtil.getNearestEntity(center, entityType, radius, e -> true);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1297 center, Class<T> entityType, double radius, Predicate<T> filter) {
        return center.method_37908().method_18467(entityType, center.method_5829().method_1014(radius)).stream().filter(e -> !e.equals((Object)center)).filter(filter).min(Comparator.comparingDouble(arg_0 -> ((class_1297)center).method_5858(arg_0)));
    }

    public static List<class_1297> getEntitiesInDirection(class_1297 from, class_243 direction, double range, double angleRadians) {
        return from.method_37908().method_8333(from, from.method_5829().method_1014(range), e -> {
            if ((double)from.method_5739(e) > range) {
                return false;
            }
            class_243 flat = KnightLibUtil.flattenXZ(e.method_19538().method_1020(from.method_19538()));
            if (flat.equals((Object)class_243.field_1353)) {
                return false;
            }
            return Math.acos(Math.max(-1.0, Math.min(1.0, KnightLibUtil.flattenXZ(direction).method_1026(flat)))) <= angleRadians / 2.0;
        });
    }

    public static class_243 flattenXZ(class_243 vector) {
        class_243 flat = new class_243(vector.field_1352, 0.0, vector.field_1350);
        return flat.method_1027() < 1.0E-6 ? class_243.field_1353 : flat.method_1029();
    }

    public static boolean hasLineOfSight(class_1297 from, class_1297 to, boolean ignoreWater, boolean ignoreLava) {
        class_3965 result = from.method_37908().method_17742(new class_3959(from.method_33571(), to.method_33571(), class_3959.class_3960.field_17558, ignoreWater && ignoreLava ? class_3959.class_242.field_1348 : class_3959.class_242.field_1347, from));
        return result.method_17783() == class_239.class_240.field_1333;
    }

    public static boolean hasLineOfSight(class_1297 from, class_1297 to) {
        return KnightLibUtil.hasLineOfSight(from, to, true, true);
    }

    public static List<class_1297> getEntitiesInLineOfSight(class_1309 from, double range, double angleRadians, Predicate<class_1297> filter) {
        class_243 eye = from.method_33571();
        return from.method_37908().method_8333((class_1297)from, new class_238(eye, eye).method_1014(range), e -> !e.equals((Object)from) && filter.test((class_1297)e)).stream().filter(e -> {
            class_243 class_2432;
            if (e instanceof class_1309) {
                class_1309 living = (class_1309)e;
                class_2432 = living.method_33571();
            } else {
                class_2432 = e.method_5829().method_1005().method_1020(eye);
            }
            class_243 toTarget = class_2432;
            double dist = toTarget.method_1033();
            if (dist > range) {
                return false;
            }
            return Math.acos(Math.max(-1.0, Math.min(1.0, from.method_5828(1.0f).method_1029().method_1026(toTarget.method_1021(1.0 / dist))))) <= angleRadians / 2.0;
        }).collect(Collectors.toList());
    }

    public static List<class_1297> getEntitiesInLineOfSight(class_1309 entity, double range) {
        return KnightLibUtil.getEntitiesInLineOfSight(entity, range, Math.toRadians(60.0), e -> true);
    }

    public static boolean canSee(class_1309 from, class_1297 to, double maxDistance, double fovRad, boolean checkLOS) {
        if ((double)from.method_5739(to) > maxDistance) {
            return false;
        }
        class_243 flat = KnightLibUtil.flattenXZ(to.method_33571().method_1020(from.method_33571()));
        if (flat.equals((Object)class_243.field_1353)) {
            return false;
        }
        return Math.acos(Math.max(-1.0, Math.min(1.0, KnightLibUtil.flattenXZ(from.method_5828(1.0f)).method_1026(flat)))) <= fovRad / 2.0 && (!checkLOS || KnightLibUtil.hasLineOfSight((class_1297)from, to));
    }

    public static boolean canSee(class_1309 from, class_1297 to, double maxDistance, double fovRad) {
        return KnightLibUtil.canSee(from, to, maxDistance, fovRad, true);
    }

    public static class_243 predictPosition(class_1297 entity, int ticks, class_243 movement) {
        class_243 vel = entity.method_18798();
        class_243 pos = entity.method_19538();
        return pos.method_1019(vel.method_1021((double)ticks)).method_1019(movement.method_1021(0.5 * (double)ticks * (double)ticks));
    }

    public static class_243 predictPosition(class_1297 entity, int ticks) {
        return KnightLibUtil.predictPosition(entity, ticks, entity.method_18798());
    }

    public static List<class_1297> getEntitiesInCircle(class_1937 level, class_243 center, double radius, Predicate<class_1297> predicate) {
        return level.method_8333((class_1297)null, new class_238(center, center).method_1014(radius), e -> e.method_19538().method_1022(center) <= radius && predicate.test((class_1297)e));
    }

    public static class_2338 findClosestGroundBelow(class_1309 entity, float y) {
        class_243 start = new class_243(entity.method_23317(), entity.method_5829().field_1322 + 0.01, entity.method_23321());
        class_3965 trace = entity.method_37908().method_17742(new class_3959(start, start.method_1023(0.0, (double)y, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)entity));
        if (trace.method_17783() == class_239.class_240.field_1332) {
            return trace.method_17777();
        }
        return null;
    }

    public static float normalizeDeg(float deg) {
        return (deg %= 360.0f) < 0.0f ? deg + 360.0f : deg;
    }

    public static float degToRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public static float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public static class_243 bezier(class_243 a, class_243 b, class_243 c, double t) {
        double u = 1.0 - t;
        double tt = t * t;
        double uu = u * u;
        return new class_243(uu * a.field_1352 + 2.0 * u * t * b.field_1352 + tt * c.field_1352, uu * a.field_1351 + 2.0 * u * t * b.field_1351 + tt * c.field_1351, uu * a.field_1350 + 2.0 * u * t * b.field_1350 + tt * c.field_1350);
    }

    public static double estimateLengthBezier(class_243 a, class_243 b, class_243 c) {
        double len = 0.0;
        class_243 prev = a;
        for (int i = 1; i <= 24; ++i) {
            double t = (double)i / 24.0;
            class_243 cur = KnightLibUtil.bezier(a, b, c, t);
            len += cur.method_1022(prev);
            prev = cur;
        }
        return len;
    }

    public static class_243 rotateHorizontalDirection(class_243 direction, double degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        return new class_243(direction.field_1352 * cos - direction.field_1350 * sin, direction.field_1351, direction.field_1352 * sin + direction.field_1350 * cos);
    }

    public static class_2338 findValidSpawnPos(class_2338 pos, class_1937 level) {
        if (KnightLibUtil.isValidSpawnPos(pos, level)) {
            return pos;
        }
        for (int d = 1; d <= 6; ++d) {
            class_2338 below = pos.method_10087(d);
            if (!KnightLibUtil.isValidSpawnPos(below, level)) continue;
            return below;
        }
        for (int u = 1; u <= 3; ++u) {
            class_2338 above = pos.method_10086(u);
            if (!KnightLibUtil.isValidSpawnPos(above, level)) continue;
            return above;
        }
        return pos;
    }

    private static boolean isValidSpawnPos(class_2338 pos, class_1937 level) {
        return level.method_24794(pos) && level.method_8320(pos).method_26215() && level.method_8320(pos.method_10074()).method_26206((class_1922)level, pos.method_10074(), class_2350.field_11036);
    }

    public static class_243 randomVectorInCone(class_243 base, double maxAngleDegrees, Random random) {
        class_243 baseNorm = base.method_1029();
        class_243 u = baseNorm.method_1036(new class_243(0.0, 1.0, 0.0));
        if (u.method_1027() < 1.0E-6) {
            u = baseNorm.method_1036(new class_243(1.0, 0.0, 0.0));
        }
        u = u.method_1029();
        class_243 v = baseNorm.method_1036(u).method_1029();
        double minCos = Math.cos(Math.toRadians(maxAngleDegrees));
        double cos = minCos + random.nextDouble() * (1.0 - minCos);
        double sin = Math.sqrt(1.0 - cos * cos);
        double phi = random.nextDouble() * 2.0 * Math.PI;
        return baseNorm.method_1021(cos).method_1019(u.method_1021(sin * Math.cos(phi))).method_1019(v.method_1021(sin * Math.sin(phi))).method_1021(base.method_1033());
    }

    public static class_2499 floatsToList(float[] arr) {
        class_2499 list = new class_2499();
        for (float v : arr) {
            list.add((Object)class_2494.method_23244((float)v));
        }
        return list;
    }

    public static class_2499 intsToList(int[] arr) {
        class_2499 list = new class_2499();
        for (int v : arr) {
            list.add((Object)class_2497.method_23247((int)v));
        }
        return list;
    }

    public static void listToFloats(class_2499 list, float[] o) {
        for (int i = 0; i < o.length && i < list.size(); ++i) {
            o[i] = ((class_2494)list.method_10534(i)).method_10700();
        }
    }

    public static void listToInts(class_2499 list, int[] o) {
        for (int i = 0; i < o.length && i < list.size(); ++i) {
            o[i] = ((class_2497)list.method_10534(i)).method_10701();
        }
    }
}

