/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.entity;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.satisfy.sleepy_hollows.core.entity.Horseman;
import net.satisfy.sleepy_hollows.core.registry.EntityTypeRegistry;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import net.satisfy.sleepy_hollows.core.registry.SoundEventRegistry;
import net.satisfy.sleepy_hollows.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class FleeingPumpkinHead
extends class_1588 {
    private final class_3213 bossEvent = new class_3213((class_2561)class_2561.method_43471((String)"entity.sleepy_hollows.fleeing_pumpkin_head"), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795);
    private boolean summonedZombiesAndSkeletonsAt75 = false;
    private boolean summonedZombiesAndSkeletonsAt25 = false;
    private boolean isFrozen = false;
    private long frozenUntil = 0L;
    private boolean increasedArmor = false;
    private Horseman summoner;
    private final Map<class_1309, Integer> flyingEntities = new HashMap<class_1309, Integer>();
    private boolean isFlyingAway = false;
    private int flightDuration;
    private int flightTicks;
    private class_243 flightStartPos;
    private class_243 flightEndPos;
    private double flightArcHeight;

    public FleeingPumpkinHead(class_1299<? extends class_1588> type, class_1937 world) {
        super(type, world);
        this.method_5665((class_2561)class_2561.method_43471((String)"entity.sleepy_hollows.fleeing_pumpkin_head"));
        this.method_5880(true);
        this.field_6201.method_6277(0, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new AvoidPlayerGoal(this, 1.1));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 15.0f));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, PlatformHelper.getFleeingPumpkinMovementSpeed()).method_26868(class_5134.field_23716, PlatformHelper.getFleeingPumpkinMaxHealth()).method_26868(class_5134.field_23721, 0.0).method_26868(class_5134.field_23724, PlatformHelper.getFleeingPumpkinArmor());
    }

    public void setSummoner(Horseman summoner) {
        this.summoner = summoner;
    }

    public void method_5773() {
        super.method_5773();
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
        if (this.isMoving()) {
            this.method_37908().method_8406((class_2394)class_2398.field_23114, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 0.0, 0.0, 0.0);
        }
        Iterator<Map.Entry<class_1309, Integer>> iterator = this.flyingEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_1309, Integer> entry = iterator.next();
            class_1309 entity = entry.getKey();
            int remainingTicks = entry.getValue();
            this.method_37908().method_8406((class_2394)class_2398.field_22246, entity.method_23317(), entity.method_23318() + 0.5, entity.method_23321(), 0.0, 0.0, 0.0);
            class_243 position = entity.method_19538();
            class_2338 currentPos = new class_2338((int)position.field_1352, (int)position.field_1351, (int)position.field_1350);
            if (!this.method_37908().method_8320(currentPos).method_26215()) {
                entity.method_5875(false);
                iterator.remove();
                continue;
            }
            if (--remainingTicks <= 0) {
                entity.method_5875(false);
                iterator.remove();
                continue;
            }
            entry.setValue(remainingTicks);
        }
        if (this.isFlyingAway) {
            double t = (double)this.flightTicks / (double)this.flightDuration;
            if (t >= 1.0) {
                this.isFlyingAway = false;
                this.field_5960 = false;
            } else {
                double x = this.flightStartPos.field_1352 + (this.flightEndPos.field_1352 - this.flightStartPos.field_1352) * t;
                double z = this.flightStartPos.field_1350 + (this.flightEndPos.field_1350 - this.flightStartPos.field_1350) * t;
                double y = this.flightStartPos.field_1351 + this.flightArcHeight * Math.sin(Math.PI * t);
                class_243 newPos = new class_243(x, y, z);
                class_2338 currentPos = new class_2338((int)Math.floor(newPos.field_1352), (int)Math.floor(newPos.field_1351), (int)Math.floor(newPos.field_1350));
                if (!this.method_37908().method_8320(currentPos).method_26215()) {
                    this.isFlyingAway = false;
                    this.field_5960 = false;
                    return;
                }
                if (!this.isPositionSafe(newPos)) {
                    this.isFlyingAway = false;
                    this.field_5960 = false;
                    return;
                }
                this.method_5859(newPos.field_1352, newPos.field_1351, newPos.field_1350);
                this.field_5982 = this.method_36454();
                this.method_36456(this.method_36454() + 10.0f);
                this.field_6241 = this.method_36454();
                this.field_6283 = this.method_36454();
                this.method_37908().method_8406((class_2394)class_2398.field_23114, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 0.0, 0.0, 0.0);
                ++this.flightTicks;
            }
        } else {
            if (this.summoner != null && this.summoner.method_5805()) {
                double distanceSq = this.method_5858((class_1297)this.summoner);
                if (distanceSq > 5625.0) {
                    this.method_5942().method_6335((class_1297)this.summoner, 1.0);
                }
            } else {
                this.summoner = null;
            }
            if (this.isFrozen && this.method_37908().method_8510() >= this.frozenUntil) {
                this.isFrozen = false;
            }
            if (this.isFrozen) {
                this.method_18799(class_243.field_1353);
                this.applyTremblingEffect();
            }
            if ((double)this.method_6032() <= (double)this.method_6063() * 0.75 && !this.summonedZombiesAndSkeletonsAt75) {
                this.summonZombiesAndSkeletons();
                this.summonedZombiesAndSkeletonsAt75 = true;
            }
            if ((double)this.method_6032() <= (double)this.method_6063() * 0.25 && !this.summonedZombiesAndSkeletonsAt25) {
                this.summonZombiesAndSkeletons();
                this.summonedZombiesAndSkeletonsAt25 = true;
            }
            if ((double)this.method_6032() <= (double)this.method_6063() * 0.5 && !this.increasedArmor) {
                this.increaseArmorByTenPercent();
                this.increasedArmor = true;
            }
        }
    }

    private boolean canSpawnEntityAt(class_2338 pos) {
        class_2338 below = pos.method_10074();
        class_2680 belowState = this.method_37908().method_8320(below);
        return this.method_37908().method_22347(pos) && this.method_37908().method_22347(pos.method_10084()) && !belowState.method_26220((class_1922)this.method_37908(), below).method_1110();
    }

    private class_2338 groundedSpawnPos(class_2338 origin) {
        int x = origin.method_10263();
        int z = origin.method_10260();
        int y = this.method_37908().method_8624(class_2902.class_2903.field_13203, x, z);
        class_2338 candidate = new class_2338(x, y, z);
        if (this.canSpawnEntityAt(candidate)) {
            return candidate;
        }
        for (int dy = 1; dy <= 3; ++dy) {
            class_2338 up = candidate.method_10086(dy);
            if (!this.canSpawnEntityAt(up)) continue;
            return up;
        }
        return origin;
    }

    private boolean isPositionSafe(class_243 pos) {
        class_2338 blockPos = new class_2338((int)Math.floor(pos.field_1352), (int)Math.floor(pos.field_1351), (int)Math.floor(pos.field_1350));
        return this.method_37908().method_22347(blockPos) && this.method_37908().method_22347(blockPos.method_10084());
    }

    private void increaseArmorByTenPercent() {
        Objects.requireNonNull(this.method_5996(class_5134.field_23724)).method_6192(Objects.requireNonNull(this.method_5996(class_5134.field_23724)).method_6201() * 1.1);
    }

    private boolean isMoving() {
        return this.method_18798().method_1027() > 0.01;
    }

    private void applyTremblingEffect() {
        double trembleAmount = 0.05;
        double trembleX = (Math.random() - 0.5) * trembleAmount;
        double trembleZ = (Math.random() - 0.5) * trembleAmount;
        this.method_5814(this.method_23317() + trembleX, this.method_23318(), this.method_23321() + trembleZ);
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (this.isFlyingAway) {
            return false;
        }
        boolean damaged = super.method_5643(source, amount);
        if (damaged) {
            this.freezeFor();
        }
        return damaged;
    }

    private void freezeFor() {
        this.isFrozen = true;
        this.frozenUntil = this.method_37908().method_8510() + 10L;
    }

    private void summonZombiesAndSkeletons() {
        class_2338 spawnPos;
        class_2338 offsetPos;
        int i;
        this.method_37908().method_8396(null, this.method_24515(), (class_3414)SoundEventRegistry.FLEEING_PUMPKIN_SUMMONING.get(), class_3419.field_15251, 1.0f, 1.0f);
        for (class_1657 player : this.method_37908().method_18456()) {
            class_3222 serverPlayer;
            if (!(player instanceof class_3222) || !(serverPlayer = (class_3222)player).method_6057((class_1297)this) || !(serverPlayer.method_5739((class_1297)this) <= 10.0f)) continue;
            serverPlayer.method_6092(new class_1293(class_1294.field_5919, 30, 3));
        }
        for (i = 0; i < 5; ++i) {
            class_1642 zombie;
            offsetPos = this.method_24515().method_10069(this.field_5974.method_43048(5) - 2, this.field_5974.method_43048(3) - 1, this.field_5974.method_43048(5) - 2);
            spawnPos = this.groundedSpawnPos(offsetPos);
            if (!this.canSpawnEntityAt(spawnPos) || (zombie = (class_1642)((class_1299)EntityTypeRegistry.INFECTED_ZOMBIE.get()).method_5883(this.method_37908())) == null) continue;
            zombie.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, this.field_5974.method_43057() * 360.0f, 0.0f);
            zombie.method_18799(class_243.field_1353);
            zombie.method_5875(false);
            zombie.method_5673(class_1304.field_6169, new class_1799((class_1935)ObjectRegistry.SPECTRAL_JACK_O_LANTERN.get()));
            zombie.method_5946(class_1304.field_6169, 0.1f);
            zombie.method_5673(class_1304.field_6174, new class_1799((class_1935)ObjectRegistry.HAUNTBOUND_CHESTPLATE.get()));
            zombie.method_5946(class_1304.field_6174, 0.01f);
            zombie.method_5673(class_1304.field_6172, new class_1799((class_1935)ObjectRegistry.HAUNTBOUND_LEGGINGS.get()));
            zombie.method_5946(class_1304.field_6172, 0.01f);
            zombie.method_5673(class_1304.field_6166, new class_1799((class_1935)ObjectRegistry.HAUNTBOUND_BOOTS.get()));
            zombie.method_5946(class_1304.field_6166, 0.01f);
            class_1799 enchantedSword = new class_1799((class_1935)ObjectRegistry.SPECTRAL_WARAXE.get());
            zombie.method_5673(class_1304.field_6173, enchantedSword);
            zombie.method_5946(class_1304.field_6173, 0.03f);
            if (zombie.method_5996(class_5134.field_23724) != null) {
                double currentArmor = Objects.requireNonNull(zombie.method_5996(class_5134.field_23724)).method_6201();
                Objects.requireNonNull(zombie.method_5996(class_5134.field_23724)).method_6192(Math.max(0.0, currentArmor - 8.0));
            }
            zombie.method_5665((class_2561)class_2561.method_43471((String)"entity.sleepy_hollows.hauntbound_zombie"));
            zombie.method_5880(false);
            this.method_37908().method_8649((class_1297)zombie);
            this.method_37908().method_8406((class_2394)class_2398.field_17909, zombie.method_23317(), zombie.method_23318() + 0.5, zombie.method_23321(), 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 2; ++i) {
            class_1613 skeleton;
            offsetPos = this.method_24515().method_10069(this.field_5974.method_43048(5) - 2, this.field_5974.method_43048(3) - 1, this.field_5974.method_43048(5) - 2);
            spawnPos = this.groundedSpawnPos(offsetPos);
            if (!this.canSpawnEntityAt(spawnPos) || (skeleton = (class_1613)class_1299.field_6137.method_5883(this.method_37908())) == null) continue;
            skeleton.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, this.field_5974.method_43057() * 360.0f, 0.0f);
            skeleton.method_18799(class_243.field_1353);
            skeleton.method_5875(false);
            skeleton.method_5673(class_1304.field_6169, new class_1799((class_1935)ObjectRegistry.SPECTRAL_JACK_O_LANTERN.get()));
            skeleton.method_5946(class_1304.field_6169, 0.1f);
            skeleton.method_5673(class_1304.field_6174, new class_1799((class_1935)ObjectRegistry.HAUNTBOUND_CHESTPLATE.get()));
            skeleton.method_5946(class_1304.field_6174, 0.01f);
            skeleton.method_5673(class_1304.field_6172, new class_1799((class_1935)ObjectRegistry.HAUNTBOUND_LEGGINGS.get()));
            skeleton.method_5946(class_1304.field_6172, 0.01f);
            skeleton.method_5673(class_1304.field_6166, new class_1799((class_1935)ObjectRegistry.HAUNTBOUND_BOOTS.get()));
            skeleton.method_5946(class_1304.field_6166, 0.01f);
            class_1799 enchantedBow = new class_1799((class_1935)class_1802.field_8102);
            skeleton.method_5673(class_1304.field_6173, enchantedBow);
            skeleton.method_5946(class_1304.field_6173, 0.01f);
            skeleton.method_5665((class_2561)class_2561.method_43471((String)"entity.sleepy_hollows.hauntbound_marksman"));
            skeleton.method_5880(false);
            this.method_37908().method_8649((class_1297)skeleton);
            this.method_37908().method_8406((class_2394)class_2398.field_17909, skeleton.method_23317(), skeleton.method_23318() + 0.5, skeleton.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    public void startFlyingAway() {
        this.isFlyingAway = true;
        this.flightDuration = 60;
        this.flightTicks = 0;
        this.flightStartPos = this.method_19538();
        double angle = this.field_5974.method_43058() * 2.0 * Math.PI;
        double distance = 15.0;
        double dx = Math.cos(angle) * distance;
        double dz = Math.sin(angle) * distance;
        this.flightEndPos = this.flightStartPos.method_1031(dx, 0.0, dz);
        this.flightArcHeight = 5.0;
        this.field_5960 = true;
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14770, class_3419.field_15251, 1.0f, 1.0f);
    }

    public void method_5837(@NotNull class_3222 player) {
        super.method_5837(player);
        this.bossEvent.method_14088(player);
    }

    public void method_5742(@NotNull class_3222 player) {
        super.method_5742(player);
        this.bossEvent.method_14089(player);
    }

    public void method_6078(@NotNull class_1282 cause) {
        super.method_6078(cause);
        this.bossEvent.method_14094();
        this.spawnFlashParticles();
    }

    private void spawnFlashParticles() {
        for (int i = 0; i < 60; ++i) {
            double xOffset = (Math.random() - 0.5) * 2.0;
            double yOffset = Math.random() * 2.0;
            double zOffset = (Math.random() - 0.5) * 2.0;
            this.method_37908().method_8406((class_2394)class_2398.field_17909, this.method_23317() + xOffset, this.method_23318() + yOffset, this.method_23321() + zOffset, 0.0, 0.0, 0.0);
        }
    }

    protected class_3414 method_6002() {
        return (class_3414)SoundEventRegistry.FLEEING_PUMPKIN_DEATH.get();
    }

    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return (class_3414)SoundEventRegistry.FLEEING_PUMPKIN_HURT.get();
    }

    protected class_3414 method_5994() {
        return (class_3414)SoundEventRegistry.FLEEING_PUMPKIN_AMBIENT.get();
    }

    public boolean method_6054() {
        return false;
    }

    public static class AvoidPlayerGoal
    extends class_1352 {
        private final FleeingPumpkinHead entity;
        private final double speed;

        public AvoidPlayerGoal(FleeingPumpkinHead entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1657 nearestPlayer = this.entity.method_37908().method_18460((class_1297)this.entity, 10.0);
            return nearestPlayer != null && !this.entity.isFrozen;
        }

        public void method_6269() {
            class_1657 nearestPlayer = this.entity.method_37908().method_18460((class_1297)this.entity, 10.0);
            if (nearestPlayer != null) {
                class_243 awayVector = this.entity.method_19538().method_1020(nearestPlayer.method_19538()).method_1029();
                class_243 targetPos = this.entity.method_19538().method_1019(awayVector.method_1021(10.0));
                if (this.entity.isPositionSafe(targetPos)) {
                    this.entity.method_5942().method_6337(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, this.speed);
                } else {
                    this.entity.method_5942().method_6337(this.entity.method_23317() + awayVector.field_1352 * 5.0, this.entity.method_23318(), this.entity.method_23321() + awayVector.field_1350 * 5.0, this.speed);
                }
            }
        }

        public boolean method_6266() {
            class_1657 nearestPlayer = this.entity.method_37908().method_18460((class_1297)this.entity, 10.0);
            return nearestPlayer != null && !this.entity.isFrozen;
        }
    }
}

