/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import net.minecraft.class_4582;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.minecraft.class_7923;
import net.minecraft.class_9381;
import net.satisfy.sleepy_hollows.core.entity.EntityWithAttackAnimation;
import net.satisfy.sleepy_hollows.core.entity.FleeingPumpkinHead;
import net.satisfy.sleepy_hollows.core.entity.ai.AnimationAttackGoal;
import net.satisfy.sleepy_hollows.core.entity.ai.NearestAttackablePlayerGoal;
import net.satisfy.sleepy_hollows.core.entity.ai.RandomAction;
import net.satisfy.sleepy_hollows.core.entity.ai.RandomActionGoal;
import net.satisfy.sleepy_hollows.core.entity.animation.ServerAnimationDurations;
import net.satisfy.sleepy_hollows.core.registry.EntityTypeRegistry;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import net.satisfy.sleepy_hollows.core.registry.SoundEventRegistry;
import net.satisfy.sleepy_hollows.core.util.ParticleArc;
import net.satisfy.sleepy_hollows.core.util.SoulfireSpiral;
import net.satisfy.sleepy_hollows.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class Horseman
extends class_1588
implements EntityWithAttackAnimation,
class_4582 {
    private static final float[] HEALTH_THRESHOLDS = new float[]{0.75f, 0.5f, 0.25f};
    private static final class_2940<Boolean> HAS_ACTIVE_PUMPKIN_HEAD = class_2945.method_12791(Horseman.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ATTACKING = class_2945.method_12791(Horseman.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IMMUNE = class_2945.method_12791(Horseman.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LAUGHING = class_2945.method_12791(Horseman.class, (class_2941)class_2943.field_13323);
    public final class_7094 attackAnimationState = new class_7094();
    public final class_7094 idleAnimationState = new class_7094();
    private final class_3213 bossEvent = new class_3213((class_2561)class_2561.method_43471((String)"entity.sleepy_hollows.horseman"), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795);
    private final List<ParticleArc> activeParticleArcs = new ArrayList<ParticleArc>();
    public class_7094 laughingAnimationState = new class_7094();
    private int nextSummonIndex = 0;
    private int idleAnimationTimeout = 0;
    private int skeletonSpawnTimer = 500;
    private int attackCounter = 0;
    private final List<SoulfireSpiral> activeSoulfireSpirals = new ArrayList<SoulfireSpiral>();
    private int nextSoulfireIndex = 0;

    public Horseman(class_1299<? extends class_1588> type, class_1937 world) {
        super(type, world);
        this.method_5665((class_2561)class_2561.method_43471((String)"entity.sleepy_hollows.horseman"));
        this.method_5880(true);
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6201.method_6277(0, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new AnimationAttackGoal(this, 1.0, true, (int)(ServerAnimationDurations.horseman_attack * 20.0f + 2.0f), 8));
        this.field_6201.method_6277(1, (class_1352)new NearestAttackablePlayerGoal((class_1308)this, 30.0));
        this.field_6201.method_6277(2, (class_1352)new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return false;
            }

            @Override
            public void onStart() {
                Horseman.this.setLaughing(true);
            }

            @Override
            public void onStop() {
                Horseman.this.setLaughing(false);
            }

            @Override
            public boolean isPossible() {
                return true;
            }

            @Override
            public void onTick(int tick) {
                if (tick == 2) {
                    Horseman.this.method_37908().method_43129(null, (class_1297)Horseman.this, (class_3414)SoundEventRegistry.HORSEMAN_LAUGH.get(), class_3419.field_15254, 1.0f, 1.0f);
                }
            }

            @Override
            public int duration() {
                return (int)(ServerAnimationDurations.horseman_laugh * 20.0f);
            }

            @Override
            public float chance() {
                return 0.01f;
            }

            @Override
            public class_1324 getAttribute(class_1320 movementSpeed) {
                return Horseman.this.method_5996(class_7923.field_41190.method_47983((Object)movementSpeed));
            }
        }));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 25.0f));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, PlatformHelper.getHorsemanMovementSpeed()).method_26868(class_5134.field_23716, PlatformHelper.getHorsemanMaxHealth()).method_26868(class_5134.field_23721, PlatformHelper.getHorsemanAttackDamage()).method_26868(class_5134.field_23722, PlatformHelper.getHorsemanAttackKnockback()).method_26868(class_5134.field_23724, PlatformHelper.getHorsemanArmor());
    }

    public void method_5773() {
        Iterator<Object> iterator;
        float[] SOULFIRE_THRESHOLDS;
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
        if (this.hasActivePumpkinHead() && !this.isPumpkinHeadAlive()) {
            this.setActivePumpkinHead(false);
        }
        if (!this.method_37908().method_8608() && this.hasActivePumpkinHead()) {
            this.method_37908().method_8421((class_1297)this, (byte)10);
        }
        if (this.isMoving()) {
            this.method_37908().method_8406((class_2394)class_2398.field_22247, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 0.0, 0.0, 0.0);
            this.method_37908().method_8406((class_2394)class_2398.field_23956, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 0.0, 0.0, 0.0);
        }
        float currentHealthRatio = this.method_6032() / this.method_6063();
        if (this.nextSummonIndex < HEALTH_THRESHOLDS.length && currentHealthRatio <= HEALTH_THRESHOLDS[this.nextSummonIndex]) {
            this.summonPumpkinHead();
            ++this.nextSummonIndex;
        }
        if (!this.method_37908().method_8608()) {
            --this.skeletonSpawnTimer;
            if (this.skeletonSpawnTimer <= 0) {
                this.spawnArmoredSkeleton();
                this.skeletonSpawnTimer = 500;
            }
        }
        if (this.nextSoulfireIndex < (SOULFIRE_THRESHOLDS = this.getSoulfireThresholds()).length && this.method_6032() <= SOULFIRE_THRESHOLDS[this.nextSoulfireIndex]) {
            this.castSoulfireSpiral();
            ++this.nextSoulfireIndex;
        }
        if (!this.method_37908().method_8608() && !this.activeSoulfireSpirals.isEmpty()) {
            iterator = this.activeSoulfireSpirals.iterator();
            while (iterator.hasNext()) {
                SoulfireSpiral spiral = (SoulfireSpiral)iterator.next();
                spiral.tick();
                if (!spiral.isFinished()) continue;
                iterator.remove();
            }
        }
        if (!this.activeParticleArcs.isEmpty()) {
            iterator = this.activeParticleArcs.iterator();
            while (iterator.hasNext()) {
                ParticleArc arc = (ParticleArc)iterator.next();
                arc.tick(this.method_37908());
                if (!arc.isFinished()) continue;
                iterator.remove();
            }
        }
        if (this.hasActivePumpkinHead()) {
            for (int i = 0; i < 3; ++i) {
                double offsetX = this.method_23317() + this.field_5974.method_43059() * 0.3;
                double offsetY = this.method_23318() + 1.0 + this.field_5974.method_43059() * 0.3;
                double offsetZ = this.method_23321() + this.field_5974.method_43059() * 0.3;
                this.method_37908().method_8406((class_2394)class_2398.field_11251, offsetX, offsetY, offsetZ, 0.0, 0.0, 0.0);
                if (this.field_5974.method_43048(4) != 0) continue;
                this.method_37908().method_8406((class_2394)class_9381.method_58255((class_2396)class_2398.field_11226, (float)0.7f, (float)0.7f, (float)0.5f), offsetX, offsetY, offsetZ, 0.0, 0.0, 0.0);
            }
        }
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
    }

    private void castSoulfireSpiral() {
        SoulfireSpiral spiral = new SoulfireSpiral(this.method_37908(), this.method_19538());
        this.activeSoulfireSpirals.add(spiral);
        if (!this.method_37908().method_8608()) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14734, class_3419.field_15251, 1.0f, 1.0f);
        }
    }

    private boolean isMoving() {
        return this.method_18798().method_1027() > 0.01;
    }

    private void summonPumpkinHead() {
        if (!this.hasActivePumpkinHead()) {
            this.setActivePumpkinHead(true);
        }
        class_2338 base = this.safeHeadSpawn(this.method_24515().method_10084());
        FleeingPumpkinHead pumpkinHead = (FleeingPumpkinHead)((class_1299)EntityTypeRegistry.FLEEING_PUMPKIN_HEAD.get()).method_5883(this.method_37908());
        if (pumpkinHead != null) {
            pumpkinHead.method_5814((double)base.method_10263() + 0.5, base.method_10264(), (double)base.method_10260() + 0.5);
            pumpkinHead.setSummoner(this);
            this.method_37908().method_8649((class_1297)pumpkinHead);
            this.field_6011.method_12778(IMMUNE, (Object)true);
            pumpkinHead.startFlyingAway();
        }
    }

    private void spawnArmoredSkeleton() {
        int ox = (int)Math.floor(this.method_23317() + this.field_5974.method_43059() * 8.0);
        int oz = (int)Math.floor(this.method_23321() + this.field_5974.method_43059() * 8.0);
        int oy = this.method_37908().method_8624(class_2902.class_2903.field_13203, ox, oz);
        class_2338 pos = new class_2338(ox, oy, oz);
        if (!this.canSpawnHeadAt(pos)) {
            return;
        }
        class_1613 skeleton = (class_1613)class_1299.field_6137.method_5883(this.method_37908());
        if (skeleton != null) {
            skeleton.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            skeleton.method_5673(class_1304.field_6169, new class_1799((class_1935)ObjectRegistry.HAUNTBOUND_HELMET.get()));
            skeleton.method_5673(class_1304.field_6174, new class_1799((class_1935)ObjectRegistry.HAUNTBOUND_CHESTPLATE.get()));
            skeleton.method_5673(class_1304.field_6172, new class_1799((class_1935)ObjectRegistry.HAUNTBOUND_LEGGINGS.get()));
            skeleton.method_5673(class_1304.field_6166, new class_1799((class_1935)ObjectRegistry.HAUNTBOUND_BOOTS.get()));
            skeleton.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
            skeleton.method_5665((class_2561)class_2561.method_43471((String)"entity.sleepy_hollows.hauntbound_skeleton"));
            skeleton.method_5880(false);
            this.method_37908().method_8649((class_1297)skeleton);
        }
    }

    public void method_5837(@NotNull class_3222 player) {
        super.method_5837(player);
        this.bossEvent.method_14088(player);
    }

    public void method_5742(@NotNull class_3222 player) {
        super.method_5742(player);
        this.bossEvent.method_14089(player);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        this.attackAnimationState.method_45317(this.isAttacking(), this.field_6012);
        this.laughingAnimationState.method_45317(this.isLaughing(), this.field_6012);
    }

    protected void method_48565(float pPartialTick) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    public boolean isAttacking() {
        return (Boolean)this.field_6011.method_12789(ATTACKING);
    }

    @Override
    public void setAttacking_(boolean attacking) {
        this.field_6011.method_12778(ATTACKING, (Object)attacking);
    }

    private boolean isLaughing() {
        return (Boolean)this.field_6011.method_12789(LAUGHING);
    }

    public void setLaughing(boolean laughing) {
        this.field_6011.method_12778(LAUGHING, (Object)laughing);
    }

    @Override
    public class_243 getPosition_(int i) {
        return super.method_30950((float)i);
    }

    @Override
    public void doHurtTarget_(class_1309 targetEntity) {
        super.method_6121((class_1297)targetEntity);
        ++this.attackCounter;
        if (this.attackCounter >= 7) {
            this.removeWaterInRadius();
            this.attackCounter = 0;
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAS_ACTIVE_PUMPKIN_HEAD, (Object)false);
        builder.method_56912(ATTACKING, (Object)false);
        builder.method_56912(IMMUNE, (Object)false);
        builder.method_56912(LAUGHING, (Object)false);
    }

    @Override
    public class_1309 getTarget_() {
        return this.method_5968();
    }

    @Override
    public double getMeleeAttackRangeSqr_(class_1309 target) {
        double w = (double)this.method_17681() * 2.0;
        return w * w + (double)target.method_17681();
    }

    private boolean isPumpkinHeadAlive() {
        class_238 searchArea = this.method_5829().method_1014(100.0);
        return !this.method_37908().method_8390(FleeingPumpkinHead.class, searchArea, class_1297::method_5805).isEmpty();
    }

    public boolean hasActivePumpkinHead() {
        return (Boolean)this.field_6011.method_12789(HAS_ACTIVE_PUMPKIN_HEAD);
    }

    public void setActivePumpkinHead(boolean active) {
        this.field_6011.method_12778(HAS_ACTIVE_PUMPKIN_HEAD, (Object)active);
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("HasActivePumpkinHead", this.hasActivePumpkinHead());
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
    }

    public void method_5711(byte id) {
        if (id == 10) {
            this.setActivePumpkinHead(true);
        } else if (id == 11) {
            this.setActivePumpkinHead(false);
        } else {
            super.method_5711(id);
        }
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (this.isPumpkinHeadAlive()) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    private boolean canSpawnHeadAt(class_2338 pos) {
        class_2338 below = pos.method_10074();
        class_2680 belowState = this.method_37908().method_8320(below);
        return this.method_37908().method_22347(pos) && this.method_37908().method_22347(pos.method_10084()) && !belowState.method_26220((class_1922)this.method_37908(), below).method_1110();
    }

    private class_2338 safeHeadSpawn(class_2338 origin) {
        int x = origin.method_10263();
        int z = origin.method_10260();
        int y = this.method_37908().method_8624(class_2902.class_2903.field_13203, x, z);
        class_2338 candidate = new class_2338(x, y, z);
        if (this.canSpawnHeadAt(candidate)) {
            return candidate;
        }
        for (int dy = 1; dy <= 4; ++dy) {
            class_2338 up = candidate.method_10086(dy);
            if (!this.canSpawnHeadAt(up)) continue;
            return up;
        }
        int r = 3;
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                int ny;
                class_2338 around;
                if (dx == 0 && dz == 0 || !this.canSpawnHeadAt(around = new class_2338(x + dx, ny = this.method_37908().method_8624(class_2902.class_2903.field_13203, x + dx, z + dz), z + dz))) continue;
                return around;
            }
        }
        return origin.method_10084();
    }

    public void method_6078(@NotNull class_1282 cause) {
        super.method_6078(cause);
        for (int i = 0; i < 70; ++i) {
            double offsetX = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 2.0;
            double offsetY = this.method_23318() + this.field_5974.method_43058() * 2.0;
            double offsetZ = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 2.0;
            this.method_37908().method_8406((class_2394)class_2398.field_11251, offsetX, offsetY, offsetZ, 0.0, 0.0, 0.0);
            this.method_37908().method_8406((class_2394)class_2398.field_23114, offsetX, offsetY, offsetZ, 0.0, 0.0, 0.0);
        }
        if (!this.method_37908().field_9236 && this.method_37908().method_8450().method_8355(class_1928.field_19391)) {
            int experienceAmount = 250;
            class_1303.method_31493((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (int)experienceAmount);
        }
    }

    private void removeWaterInRadius() {
        class_238 area = new class_238(this.method_24515()).method_1014(10.0);
        class_2338.method_29715((class_238)area).forEach(pos -> {
            if (this.method_37908().method_8316(pos).method_15771()) {
                if (this.method_37908().method_8608()) {
                    this.method_37908().method_20290(2001, pos, class_2248.method_9507((class_2680)this.method_37908().method_8320(pos)));
                }
                this.method_37908().method_8652(pos, ((class_2248)ObjectRegistry.GRAVESTONE.get()).method_9564(), 3);
                if (this.method_37908().method_8608()) {
                    class_243 targetPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
                    class_243 horsemanPos = new class_243(this.method_23317(), this.method_23318() + 1.0, this.method_23321());
                    ParticleArc arc = new ParticleArc(targetPos, horsemanPos, 40);
                    this.activeParticleArcs.add(arc);
                }
            }
        });
    }

    public void method_6005(double strength, double xRatio, double zRatio) {
    }

    protected class_3414 method_6002() {
        return (class_3414)SoundEventRegistry.HORSEMAN_DEATH.get();
    }

    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return (class_3414)SoundEventRegistry.HORSEMAN_HIT.get();
    }

    protected class_3414 method_5994() {
        return class_3417.field_14984;
    }

    private float[] getSoulfireThresholds() {
        float maxHealth = this.method_6063();
        float[] thresholds = new float[10];
        for (int i = 0; i < 10; ++i) {
            thresholds[i] = maxHealth * (1.0f - (float)i * 0.1f);
        }
        return thresholds;
    }

    public boolean method_6054() {
        return true;
    }

    public boolean method_6872() {
        return (Boolean)this.field_6011.method_12789(IMMUNE);
    }

    protected void method_6099(@NotNull class_3218 level, @NotNull class_1282 source, boolean recentlyHit) {
        super.method_6099(level, source, recentlyHit);
        List<class_1799> horsemanLoot = PlatformHelper.getHorsemanLootItems();
        for (class_1799 loot : horsemanLoot) {
            this.method_5775(loot);
        }
    }
}

