/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.config.BiolithGeneralConfig;
import com.terraformersmc.biolith.impl.platform.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class BiolithConfigManager {
    private final Path generalConfigPath;
    private final Path generalConfigBackupPath;
    private BiolithGeneralConfig generalConfig;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();

    public BiolithConfigManager() {
        Path configDirectory = Services.PLATFORM.getConfigDir().resolve("biolith");
        try {
            Files.createDirectories(configDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            Biolith.LOGGER.error("Failed to create config directory at " + String.valueOf(configDirectory), (Throwable)e);
        }
        this.generalConfigPath = configDirectory.resolve("general.json");
        this.generalConfigBackupPath = configDirectory.resolve("general-invalid-syntax.json");
    }

    private static <T> T loadConfig(Path configPath, T defaults, Class<T> clazz, Path backupPath) {
        String content;
        if (!Files.exists(configPath, new LinkOption[0]) && !BiolithConfigManager.saveConfig(configPath, defaults)) {
            Biolith.LOGGER.error("Unable to save default configuration values for " + String.valueOf(configPath));
            return defaults;
        }
        try {
            content = Files.readString(configPath);
        }
        catch (IOException e) {
            Biolith.LOGGER.error("Failed to load Biolith configuration file at " + String.valueOf(configPath), (Throwable)e);
            Biolith.LOGGER.error("This shouldn't happen under normal conditions, ensure that you have the correct permissions");
            Biolith.LOGGER.error("Reverting to default configuration");
            return defaults;
        }
        try {
            return (T)GSON.fromJson(content, clazz);
        }
        catch (JsonSyntaxException e) {
            Biolith.LOGGER.error("Failed to parse Biolith configuration file at " + String.valueOf(configPath), (Throwable)e);
            Biolith.LOGGER.error("Reverting to default configuration, ensure that your file has correct syntax");
            BiolithConfigManager.saveConfig(configPath, defaults);
            Biolith.LOGGER.error("In the future, consider using something like https://jsonchecker.com/ to check your syntax");
            Biolith.LOGGER.error("The previous configuration file content has been written to " + String.valueOf(backupPath));
            try {
                Files.writeString(backupPath, (CharSequence)content, new OpenOption[0]);
            }
            catch (IOException ioe) {
                Biolith.LOGGER.error("Couldn't save previous configuration file content at " + String.valueOf(backupPath), (Throwable)ioe);
                Biolith.LOGGER.error("This shouldn't happen under normal conditions, ensure that you have the correct permissions and that your disk isn't full!");
            }
            return defaults;
        }
    }

    private static <T> boolean saveConfig(Path configPath, T instance) {
        String jsonString = GSON.toJson(instance);
        try {
            Files.writeString(configPath, (CharSequence)jsonString, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            Biolith.LOGGER.error("Couldn't save Biolith configuration file at " + String.valueOf(configPath), (Throwable)e);
            Biolith.LOGGER.error("This shouldn't happen under normal conditions, ensure that you have the correct permissions and that your disk isn't full!");
            return false;
        }
    }

    public BiolithGeneralConfig getGeneralConfig() {
        if (this.generalConfig == null) {
            this.generalConfig = BiolithConfigManager.loadConfig(this.generalConfigPath, new BiolithGeneralConfig(), BiolithGeneralConfig.class, this.generalConfigBackupPath);
        }
        return this.generalConfig;
    }
}

