/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.data.BiomePlacementMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class BiomePlacementLoader
extends class_4080<List<BiomePlacementMarshaller>> {
    public static final String RESOURCE_PATH = "biolith/biome_placement.json";

    protected List<BiomePlacementMarshaller> prepare(class_3300 manager, class_3695 profiler) {
        profiler.method_16065();
        ArrayList<BiomePlacementMarshaller> marshallers = new ArrayList<BiomePlacementMarshaller>();
        for (String namespace : manager.method_14487()) {
            profiler.method_15396(namespace);
            try {
                for (class_3298 resource : manager.method_14489(class_2960.method_60655((String)namespace, (String)RESOURCE_PATH))) {
                    profiler.method_15396(resource.method_14480());
                    try {
                        InputStream inputStream = resource.method_14482();
                        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                            profiler.method_15396("parse");
                            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            BiomePlacementMarshaller marshaller = BiomePlacementLoader.get(BiomePlacementMarshaller.CODEC, (JsonElement)jsonObject);
                            if (marshaller == null) {
                                throw new RuntimeException();
                            }
                            marshallers.add(marshaller);
                            profiler.method_15407();
                        }
                        catch (Throwable throwable) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable closeBreak) {
                                    throwable.addSuppressed(closeBreak);
                                }
                            }
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    catch (RuntimeException runtimeBreak) {
                        Biolith.LOGGER.warn("Invalid {} in resourcepack: '{}'", new Object[]{RESOURCE_PATH, resource.method_14480(), runtimeBreak});
                    }
                    profiler.method_15407();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            profiler.method_15407();
        }
        profiler.method_16066();
        return marshallers;
    }

    protected void apply(List<BiomePlacementMarshaller> marshallers, class_3300 manager, class_3695 profiler) {
        if (BiomeCoordinator.isServerStarted()) {
            Biolith.LOGGER.warn("Ignoring request to reload biome placement data while server is running.");
            return;
        }
        if (marshallers.size() > 0) {
            Biolith.LOGGER.info("Applying biome placement data from {} source(s).", (Object)marshallers.size());
        }
        BiomeCoordinator.OVERWORLD.clearFromData();
        BiomeCoordinator.NETHER.clearFromData();
        BiomeCoordinator.END.clearFromData();
        for (BiomePlacementMarshaller marshaller : marshallers) {
            marshaller.unmarshall();
        }
    }

    public static <R> R get(Decoder<R> decoder, JsonElement jsonElement) throws NullPointerException {
        return (R)decoder.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).result().orElseThrow();
    }
}

