/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2874;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_7134;
import net.minecraft.class_7924;

public record BiomePlacementMarshaller(List<AddBiomeMarshaller> additions, List<RemoveBiomeMarshaller> removals, List<ReplaceBiomeMarshaller> replacements, List<AddSubBiomeMarshaller> subBiomes) {
    public static final Codec<BiomePlacementMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AddBiomeMarshaller.CODEC.listOf().optionalFieldOf("additions", List.of()).forGetter(BiomePlacementMarshaller::additions), (App)RemoveBiomeMarshaller.CODEC.listOf().optionalFieldOf("removals", List.of()).forGetter(BiomePlacementMarshaller::removals), (App)ReplaceBiomeMarshaller.CODEC.listOf().optionalFieldOf("replacements", List.of()).forGetter(BiomePlacementMarshaller::replacements), (App)AddSubBiomeMarshaller.CODEC.listOf().optionalFieldOf("sub_biomes", List.of()).forGetter(BiomePlacementMarshaller::subBiomes)).apply((Applicative)instance, BiomePlacementMarshaller::new));

    public void unmarshall() {
        for (AddBiomeMarshaller addBiomeMarshaller : this.additions) {
            addBiomeMarshaller.unmarshall();
        }
        for (RemoveBiomeMarshaller removeBiomeMarshaller : this.removals) {
            removeBiomeMarshaller.unmarshall();
        }
        for (ReplaceBiomeMarshaller replaceBiomeMarshaller : this.replacements) {
            replaceBiomeMarshaller.unmarshall();
        }
        for (AddSubBiomeMarshaller addSubBiomeMarshaller : this.subBiomes) {
            addSubBiomeMarshaller.unmarshall();
        }
    }

    public record AddBiomeMarshaller(class_5321<class_2874> dimension, class_5321<class_1959> biome, class_6544.class_4762 noisePoint) {
        public static Codec<AddBiomeMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41241).fieldOf("dimension").forGetter(AddBiomeMarshaller::dimension), (App)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("biome").forGetter(AddBiomeMarshaller::biome), (App)class_6544.class_4762.field_24679.fieldOf("noise").forGetter(AddBiomeMarshaller::noisePoint)).apply((Applicative)instance, AddBiomeMarshaller::new));

        public void unmarshall() {
            if (this.dimension.equals((Object)class_7134.field_37666)) {
                BiomeCoordinator.OVERWORLD.addPlacement(this.biome, this.noisePoint, true);
            } else if (this.dimension.equals((Object)class_7134.field_37667)) {
                BiomeCoordinator.NETHER.addPlacement(this.biome, this.noisePoint, true);
            } else if (this.dimension.equals((Object)class_7134.field_37668)) {
                BiomeCoordinator.END.addPlacement(this.biome, this.noisePoint, true);
            } else {
                Biolith.LOGGER.warn("Ignored unknown dimension type '{}' while serializing biome placement.", (Object)this.dimension.method_29177());
            }
        }
    }

    public record RemoveBiomeMarshaller(class_5321<class_2874> dimension, class_5321<class_1959> biome) {
        public static Codec<RemoveBiomeMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41241).fieldOf("dimension").forGetter(RemoveBiomeMarshaller::dimension), (App)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("biome").forGetter(RemoveBiomeMarshaller::biome)).apply((Applicative)instance, RemoveBiomeMarshaller::new));

        public void unmarshall() {
            if (this.dimension.equals((Object)class_7134.field_37666)) {
                BiomeCoordinator.OVERWORLD.addRemoval(this.biome, true);
            } else if (this.dimension.equals((Object)class_7134.field_37667)) {
                BiomeCoordinator.NETHER.addRemoval(this.biome, true);
            } else if (this.dimension.equals((Object)class_7134.field_37668)) {
                BiomeCoordinator.END.addRemoval(this.biome, true);
            } else {
                Biolith.LOGGER.warn("Ignored unknown dimension type '{}' while serializing biome placement.", (Object)this.dimension.method_29177());
            }
        }
    }

    public record ReplaceBiomeMarshaller(class_5321<class_2874> dimension, class_5321<class_1959> target, class_5321<class_1959> biome, double proportion) {
        public static Codec<ReplaceBiomeMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41241).fieldOf("dimension").forGetter(ReplaceBiomeMarshaller::dimension), (App)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("target").forGetter(ReplaceBiomeMarshaller::target), (App)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("biome").forGetter(ReplaceBiomeMarshaller::biome), (App)Codec.DOUBLE.optionalFieldOf("proportion", (Object)1.0).forGetter(ReplaceBiomeMarshaller::proportion)).apply((Applicative)instance, ReplaceBiomeMarshaller::new));

        public void unmarshall() {
            if (this.dimension.equals((Object)class_7134.field_37666)) {
                BiomeCoordinator.OVERWORLD.addReplacement(this.target, this.biome, this.proportion, true);
            } else if (this.dimension.equals((Object)class_7134.field_37667)) {
                BiomeCoordinator.NETHER.addReplacement(this.target, this.biome, this.proportion, true);
            } else if (this.dimension.equals((Object)class_7134.field_37668)) {
                BiomeCoordinator.END.addReplacement(this.target, this.biome, this.proportion, true);
            } else {
                Biolith.LOGGER.warn("Ignored unknown dimension type '{}' while serializing biome placement.", (Object)this.dimension.method_29177());
            }
        }
    }

    public record AddSubBiomeMarshaller(class_5321<class_2874> dimension, class_5321<class_1959> target, class_5321<class_1959> biome, Criterion criterion) {
        public static Codec<AddSubBiomeMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41241).fieldOf("dimension").forGetter(AddSubBiomeMarshaller::dimension), (App)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("target").forGetter(AddSubBiomeMarshaller::target), (App)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("biome").forGetter(AddSubBiomeMarshaller::biome), (App)Criterion.MATCHER_CODEC.fieldOf("criterion").forGetter(AddSubBiomeMarshaller::criterion)).apply((Applicative)instance, AddSubBiomeMarshaller::new));

        public void unmarshall() {
            if (this.dimension.equals((Object)class_7134.field_37666)) {
                BiomeCoordinator.OVERWORLD.addSubBiome(this.target, this.biome, this.criterion, true);
            } else if (this.dimension.equals((Object)class_7134.field_37667)) {
                BiomeCoordinator.NETHER.addSubBiome(this.target, this.biome, this.criterion, true);
            } else if (this.dimension.equals((Object)class_7134.field_37668)) {
                BiomeCoordinator.END.addSubBiome(this.target, this.biome, this.criterion, true);
            } else {
                Biolith.LOGGER.warn("Ignored unknown dimension type '{}' while serializing biome placement.", (Object)this.dimension.method_29177());
            }
        }
    }
}

