/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.surface.SurfaceRuleCollector;
import java.util.List;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6686;
import net.minecraft.class_7134;
import net.minecraft.class_7924;

public record SurfaceGenerationMarshaller(List<SurfaceRuleMarshaller> surfaceRules) {
    public static final Codec<SurfaceGenerationMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SurfaceRuleMarshaller.CODEC.listOf().optionalFieldOf("surface_rules", List.of()).forGetter(SurfaceGenerationMarshaller::surfaceRules)).apply((Applicative)instance, SurfaceGenerationMarshaller::new));

    public void unmarshall() {
        for (SurfaceRuleMarshaller surfaceRule : this.surfaceRules) {
            surfaceRule.unmarshall();
        }
    }

    public record SurfaceRuleMarshaller(class_5321<class_2874> dimension, class_2960 rulesOwner, List<class_6686.class_6708> materialRules) {
        public static Codec<SurfaceRuleMarshaller> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41241).fieldOf("dimension").forGetter(SurfaceRuleMarshaller::dimension), (App)class_2960.field_25139.fieldOf("rules_owner").forGetter(SurfaceRuleMarshaller::rulesOwner), (App)class_6686.class_6708.field_35252.listOf().optionalFieldOf("material_rules", List.of()).forGetter(SurfaceRuleMarshaller::materialRules)).apply((Applicative)instance, SurfaceRuleMarshaller::new));

        public void unmarshall() {
            if (this.dimension.equals((Object)class_7134.field_37666)) {
                SurfaceRuleCollector.OVERWORLD.addFromData(this.rulesOwner, this.materialRules.toArray(new class_6686.class_6708[0]));
            } else if (this.dimension.equals((Object)class_7134.field_37667)) {
                SurfaceRuleCollector.NETHER.addFromData(this.rulesOwner, this.materialRules.toArray(new class_6686.class_6708[0]));
            } else if (this.dimension.equals((Object)class_7134.field_37668)) {
                SurfaceRuleCollector.END.addFromData(this.rulesOwner, this.materialRules.toArray(new class_6686.class_6708[0]));
            } else {
                Biolith.LOGGER.warn("Ignored unknown dimension type '{}' while serializing surface generation.", (Object)this.dimension.method_29177());
            }
        }
    }
}

