/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.client.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.satisfy.sleepy_hollows.core.registry.TagRegistry;
import net.satisfy.sleepy_hollows.core.util.SanityManager;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsIdentifier;
import net.satisfy.sleepy_hollows.core.world.SleepyHollowsBiomeKeys;

public class HUDRenderEvent {
    private static final ResourceLocation FRAME_TEXTURE = new SleepyHollowsIdentifier("textures/gui/sanity_meter_bar.png");
    private static final ResourceLocation FILL_TEXTURE = new SleepyHollowsIdentifier("textures/gui/sanity_meter_progress.png");
    private static long lastExitedBiomeTime = 0L;
    private static final long DISPLAY_DURATION_AFTER_EXIT = 45000L;

    public static void onRenderHUD(GuiGraphics guiGraphics, float tickDelta) {
        boolean shouldRender;
        LocalPlayer localPlayer;
        LocalPlayer player;
        Minecraft mc;
        block8: {
            block7: {
                mc = Minecraft.m_91087_();
                ClientLevel level = mc.f_91073_;
                player = mc.f_91074_;
                if (!(player instanceof LocalPlayer)) break block7;
                localPlayer = player;
                if (level != null && !mc.m_91104_()) break block8;
            }
            return;
        }
        if (SanityManager.isClientImmune(localPlayer) || mc.f_91073_.m_8055_(player.m_20183_()).m_204336_(TagRegistry.RESET_SANITY)) {
            return;
        }
        int sanity = SanityManager.getClientSanity(localPlayer);
        boolean isInSleepyHollows = player.m_9236_().m_204166_(player.m_20183_()).m_203565_(SleepyHollowsBiomeKeys.SLEEPY_HOLLOWS);
        if (!isInSleepyHollows && lastExitedBiomeTime == 0L) {
            lastExitedBiomeTime = System.currentTimeMillis();
        }
        if (isInSleepyHollows) {
            lastExitedBiomeTime = 0L;
        }
        boolean bl = shouldRender = isInSleepyHollows || lastExitedBiomeTime != 0L && System.currentTimeMillis() - lastExitedBiomeTime <= 45000L;
        if (!shouldRender || sanity == 100) {
            return;
        }
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int frameWidth = 214;
        int frameHeight = 32;
        int barWidth = 214;
        int barXOffset = 0;
        int barYOffset = 0;
        int x = screenWidth / 2 - frameWidth / 2;
        int y = screenHeight / 2 - 132;
        int fillWidth = (int)((float)sanity / 100.0f * (float)barWidth);
        guiGraphics.m_280163_(FILL_TEXTURE, x + barXOffset, y + barYOffset, 0.0f, 0.0f, fillWidth, frameHeight, barWidth, frameHeight);
        guiGraphics.m_280163_(FRAME_TEXTURE, x, y, 0.0f, 0.0f, frameWidth, frameHeight, frameWidth, frameHeight);
    }
}

