/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsIdentifier;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SpectralHorseModel<T extends AbstractHorse>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new SleepyHollowsIdentifier("spectral_horse"), "main");
    private static final float DEG_125 = 2.1816616f;
    private static final float DEG_60 = 1.0471976f;
    private static final float DEG_45 = 0.7853982f;
    private static final float DEG_30 = 0.5235988f;
    private static final float DEG_15 = 0.2617994f;
    protected static final String HEAD_PARTS = "head_parts";
    private static final String LEFT_HIND_BABY_LEG = "left_hind_baby_leg";
    private static final String RIGHT_HIND_BABY_LEG = "right_hind_baby_leg";
    private static final String LEFT_FRONT_BABY_LEG = "left_front_baby_leg";
    private static final String RIGHT_FRONT_BABY_LEG = "right_front_baby_leg";
    private static final String SADDLE = "saddle";
    private static final String LEFT_SADDLE_MOUTH = "left_saddle_mouth";
    private static final String LEFT_SADDLE_LINE = "left_saddle_line";
    private static final String RIGHT_SADDLE_MOUTH = "right_saddle_mouth";
    private static final String RIGHT_SADDLE_LINE = "right_saddle_line";
    private static final String HEAD_SADDLE = "head_saddle";
    private static final String MOUTH_SADDLE_WRAP = "mouth_saddle_wrap";
    protected final ModelPart body;
    protected final ModelPart headParts;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindBabyLeg;
    private final ModelPart leftHindBabyLeg;
    private final ModelPart rightFrontBabyLeg;
    private final ModelPart leftFrontBabyLeg;
    private final ModelPart tail;
    private final ModelPart[] saddleParts;
    private final ModelPart[] ridingParts;

    public SpectralHorseModel(ModelPart modelPart) {
        super(true, 16.2f, 1.36f, 2.7272f, 2.0f, 20.0f);
        this.body = modelPart.m_171324_("body");
        this.headParts = modelPart.m_171324_(HEAD_PARTS);
        this.rightHindLeg = modelPart.m_171324_("right_hind_leg");
        this.leftHindLeg = modelPart.m_171324_("left_hind_leg");
        this.rightFrontLeg = modelPart.m_171324_("right_front_leg");
        this.leftFrontLeg = modelPart.m_171324_("left_front_leg");
        this.rightHindBabyLeg = modelPart.m_171324_(RIGHT_HIND_BABY_LEG);
        this.leftHindBabyLeg = modelPart.m_171324_(LEFT_HIND_BABY_LEG);
        this.rightFrontBabyLeg = modelPart.m_171324_(RIGHT_FRONT_BABY_LEG);
        this.leftFrontBabyLeg = modelPart.m_171324_(LEFT_FRONT_BABY_LEG);
        this.tail = this.body.m_171324_("tail");
        ModelPart modelPart2 = this.body.m_171324_(SADDLE);
        ModelPart modelPart3 = this.headParts.m_171324_(LEFT_SADDLE_MOUTH);
        ModelPart modelPart4 = this.headParts.m_171324_(RIGHT_SADDLE_MOUTH);
        ModelPart modelPart5 = this.headParts.m_171324_(LEFT_SADDLE_LINE);
        ModelPart modelPart6 = this.headParts.m_171324_(RIGHT_SADDLE_LINE);
        ModelPart modelPart7 = this.headParts.m_171324_(HEAD_SADDLE);
        ModelPart modelPart8 = this.headParts.m_171324_(MOUTH_SADDLE_WRAP);
        this.saddleParts = new ModelPart[]{modelPart2, modelPart3, modelPart4, modelPart7, modelPart8};
        this.ridingParts = new ModelPart[]{modelPart5, modelPart6};
    }

    public static LayerDefinition getTexturedModelData() {
        CubeDeformation cubeDeformation = new CubeDeformation(0.0f);
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition partDefinition2 = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-5.0f, -8.0f, -17.0f, 10.0f, 10.0f, 22.0f, new CubeDeformation(0.05f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)5.0f));
        PartDefinition additional_armor = partDefinition2.m_171599_("additional_armor", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-5.0f, -21.0f, -11.0f, 10.0f, 16.0f, 22.0f, new CubeDeformation(0.2f)).m_171514_(0, 104).m_171488_(-5.0f, -21.0f, -11.0f, 10.0f, 15.0f, 9.0f, new CubeDeformation(0.25f)).m_171514_(64, 54).m_171488_(-5.0f, -21.0f, 4.0f, 10.0f, 16.0f, 10.0f, new CubeDeformation(0.25f)).m_171514_(32, 79).m_171488_(-6.0f, -26.0f, 3.99f, 12.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 74).m_171488_(-4.0f, -29.0f, 3.99f, 8.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 69).m_171488_(-5.0f, -32.0f, 3.99f, 10.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)-9.0f));
        PartDefinition saddle_decoration_r1 = additional_armor.m_171599_("saddle_decoration_r1", CubeListBuilder.m_171558_().m_171514_(88, 115).m_171488_(-10.0f, -34.0f, 1.0f, 20.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 64).m_171488_(-5.0f, -19.0f, -16.0f, 10.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition armor_body_front_decoration_left_r1 = additional_armor.m_171599_("armor_body_front_decoration_left_r1", CubeListBuilder.m_171558_().m_171514_(56, 4).m_171488_(-5.0f, -28.0f, 5.0f, 0.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(56, 4).m_171480_().m_171488_(-5.0f, -28.0f, 21.0f, 0.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-16.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition armor_body_front_decoration_right_r1 = additional_armor.m_171599_("armor_body_front_decoration_right_r1", CubeListBuilder.m_171558_().m_171514_(56, 4).m_171488_(5.0f, -28.0f, 5.0f, 0.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(56, 4).m_171480_().m_171488_(5.0f, -28.0f, 21.0f, 0.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-16.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition armor_body_front_r1 = additional_armor.m_171599_("armor_body_front_r1", CubeListBuilder.m_171558_().m_171514_(38, 107).m_171488_(-5.0f, -20.0f, -14.0f, 10.0f, 15.0f, 6.0f, new CubeDeformation(0.3f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition partDefinition3 = partDefinition.m_171599_(HEAD_PARTS, CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-2.05f, -6.0f, -2.0f, 4.0f, 12.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-12.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition partDefinition4 = partDefinition3.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-3.0f, -11.0f, -2.0f, 6.0f, 5.0f, 7.0f, cubeDeformation), PartPose.f_171404_);
        PartDefinition additional_armor_head = partDefinition4.m_171599_("additional_armor_head", CubeListBuilder.m_171558_().m_171514_(66, 42).m_171488_(-3.0f, -5.0f, -6.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.1f)).m_171514_(64, 82).m_171488_(-2.0f, -5.0f, -11.0f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.1f)).m_171514_(32, 66).m_171488_(-0.5f, -7.1534f, -8.4088f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(32, 66).m_171488_(-0.5f, -7.1534f, -3.4088f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)5.0f));
        partDefinition3.m_171599_("mane", CubeListBuilder.m_171558_().m_171514_(56, 36).m_171488_(-1.0f, -11.0f, 5.01f, 2.0f, 16.0f, 2.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition3.m_171599_("upper_mouth", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-2.0f, -11.0f, -7.0f, 4.0f, 5.0f, 5.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)-12.0f));
        partDefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)-12.0f));
        CubeDeformation cubeDeformation2 = cubeDeformation.m_171471_(0.0f, 5.5f, 0.0f);
        partDefinition.m_171599_(LEFT_HIND_BABY_LEG, CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_(RIGHT_HIND_BABY_LEG, CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_(LEFT_FRONT_BABY_LEG, CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)-12.0f));
        partDefinition.m_171599_(RIGHT_FRONT_BABY_LEG, CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)-12.0f));
        partDefinition2.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(42, 36).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 4.0f, cubeDeformation), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)2.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        partDefinition2.m_171599_(SADDLE, CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-5.0f, -8.0f, -9.0f, 10.0f, 9.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        partDefinition3.m_171599_(LEFT_SADDLE_MOUTH, CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(2.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition3.m_171599_(RIGHT_SADDLE_MOUTH, CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(-3.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition3.m_171599_(LEFT_SADDLE_LINE, CubeListBuilder.m_171558_().m_171514_(32, 2).m_171481_(3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.m_171430_((float)-0.5235988f, (float)0.0f, (float)0.0f));
        partDefinition3.m_171599_(RIGHT_SADDLE_LINE, CubeListBuilder.m_171558_().m_171514_(32, 2).m_171481_(-3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.m_171430_((float)-0.5235988f, (float)0.0f, (float)0.0f));
        partDefinition3.m_171599_(HEAD_SADDLE, CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-3.0f, -11.0f, -1.9f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.22f)), PartPose.f_171404_);
        partDefinition3.m_171599_(MOUTH_SADDLE_WRAP, CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-2.0f, -11.0f, -4.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.f_171404_);
        partDefinition4.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(19, 16).m_171488_(0.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.f_171404_);
        partDefinition4.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(19, 16).m_171488_(-2.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public void setupAnim(T abstractHorse, float f, float g, float h, float i, float j) {
        boolean hasSaddle = abstractHorse.m_6254_();
        boolean hasPassenger = abstractHorse.m_20160_();
        for (ModelPart modelPart : this.saddleParts) {
            modelPart.f_104207_ = hasSaddle;
        }
        for (ModelPart modelPart : this.ridingParts) {
            modelPart.f_104207_ = hasPassenger && hasSaddle;
        }
        this.body.f_104201_ = 11.0f;
    }

    @NotNull
    public Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.headParts);
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindBabyLeg, (Object)this.leftHindBabyLeg, (Object)this.rightFrontBabyLeg, (Object)this.leftFrontBabyLeg);
    }

    public void prepareMobModel(@NotNull T abstractHorse, float limbSwing, float limbSwingAmount, float partialTick) {
        this.m_5608_().forEach(ModelPart::m_233569_);
        this.m_5607_().forEach(ModelPart::m_233569_);
        float yBodyLerpedRotationDegrees = Mth.m_14189_((float)partialTick, (float)((AbstractHorse)abstractHorse).f_20884_, (float)((AbstractHorse)abstractHorse).f_20883_);
        float yHeadLerpedRotationDegrees = Mth.m_14189_((float)partialTick, (float)((AbstractHorse)abstractHorse).f_20886_, (float)((AbstractHorse)abstractHorse).f_20885_);
        float xEntityLerpedRotationDegrees = Mth.m_14179_((float)partialTick, (float)((AbstractHorse)abstractHorse).f_19860_, (float)abstractHorse.m_146909_());
        float headRotToBodyRotDifferenceDegrees = yHeadLerpedRotationDegrees - yBodyLerpedRotationDegrees;
        float xEntityLerpedRotationRadians = xEntityLerpedRotationDegrees * ((float)Math.PI / 180);
        if (headRotToBodyRotDifferenceDegrees > 20.0f) {
            headRotToBodyRotDifferenceDegrees = 20.0f;
        }
        if (headRotToBodyRotDifferenceDegrees < -20.0f) {
            headRotToBodyRotDifferenceDegrees = -20.0f;
        }
        if (limbSwingAmount > 0.2f) {
            xEntityLerpedRotationRadians += Mth.m_14089_((float)(limbSwing * 0.8f)) * 0.15f * limbSwingAmount;
        }
        float eatingAnimationNextValue = abstractHorse.m_30663_(partialTick);
        float standingAnimationNextValue = abstractHorse.m_30667_(partialTick);
        float standingAnimationOffset = 1.0f - standingAnimationNextValue;
        float mouthAnimationNextValue = abstractHorse.m_30533_(partialTick);
        boolean movingTail = ((AbstractHorse)abstractHorse).f_30517_ != 0;
        float tickCountNextValue = (float)((AbstractHorse)abstractHorse).f_19797_ + partialTick;
        this.headParts.f_104201_ = 4.0f;
        this.headParts.f_104202_ = -12.0f;
        this.body.f_104203_ = 0.0f;
        this.headParts.f_104203_ = 0.5235988f + xEntityLerpedRotationRadians;
        this.headParts.f_104204_ = headRotToBodyRotDifferenceDegrees * ((float)Math.PI / 180);
        float notSwimmingAnimationDampener = abstractHorse.m_20069_() ? 0.2f : 1.0f;
        float legSwingAnimationNextValueMultiplier = Mth.m_14089_((float)(notSwimmingAnimationDampener * limbSwing * 0.6662f + (float)Math.PI));
        float legSwingAnimationNextValue = legSwingAnimationNextValueMultiplier * 0.8f * limbSwingAmount;
        float calculateHeadAdditionalRotation = (1.0f - Math.max(standingAnimationNextValue, eatingAnimationNextValue)) * (0.5235988f + xEntityLerpedRotationRadians + mouthAnimationNextValue * Mth.m_14031_((float)tickCountNextValue) * 0.05f);
        this.headParts.f_104203_ = standingAnimationNextValue * (0.2617994f + xEntityLerpedRotationRadians) + eatingAnimationNextValue * (2.1816616f + Mth.m_14031_((float)tickCountNextValue) * 0.05f) + calculateHeadAdditionalRotation;
        this.headParts.f_104204_ = standingAnimationNextValue * headRotToBodyRotDifferenceDegrees * ((float)Math.PI / 180) + (1.0f - Math.max(standingAnimationNextValue, eatingAnimationNextValue)) * this.headParts.f_104204_;
        this.headParts.f_104201_ = standingAnimationNextValue * -4.0f + eatingAnimationNextValue * 11.0f + (1.0f - Math.max(standingAnimationNextValue, eatingAnimationNextValue)) * this.headParts.f_104201_;
        this.headParts.f_104202_ = standingAnimationNextValue * -4.0f + eatingAnimationNextValue * -12.0f + (1.0f - Math.max(standingAnimationNextValue, eatingAnimationNextValue)) * this.headParts.f_104202_;
        this.body.f_104203_ = standingAnimationNextValue * -0.7853982f + standingAnimationOffset * this.body.f_104203_;
        float updatedAnimationAmountWithStandingAnim = 0.2617994f * standingAnimationNextValue;
        float smoothingValue = Mth.m_14089_((float)(tickCountNextValue * 0.6f + (float)Math.PI));
        this.leftFrontLeg.f_104201_ = 2.0f * standingAnimationNextValue + 14.0f * standingAnimationOffset;
        this.leftFrontLeg.f_104202_ = -6.0f * standingAnimationNextValue - 10.0f * standingAnimationOffset;
        this.rightFrontLeg.f_104201_ = this.leftFrontLeg.f_104201_;
        this.rightFrontLeg.f_104202_ = this.leftFrontLeg.f_104202_;
        float leftFrontLegNewRotation = (-1.0471976f + smoothingValue) * standingAnimationNextValue + legSwingAnimationNextValue * standingAnimationOffset;
        float rightFrontLegNewRotation = (-1.0471976f - smoothingValue) * standingAnimationNextValue - legSwingAnimationNextValue * standingAnimationOffset;
        this.leftHindLeg.f_104203_ = updatedAnimationAmountWithStandingAnim - legSwingAnimationNextValueMultiplier * 0.5f * limbSwingAmount * standingAnimationOffset;
        this.rightHindLeg.f_104203_ = updatedAnimationAmountWithStandingAnim + legSwingAnimationNextValueMultiplier * 0.5f * limbSwingAmount * standingAnimationOffset;
        this.leftFrontLeg.f_104203_ = leftFrontLegNewRotation;
        this.rightFrontLeg.f_104203_ = rightFrontLegNewRotation;
        this.tail.f_104203_ = 0.5235988f + limbSwingAmount * 0.75f;
        this.tail.f_104201_ = -5.0f + limbSwingAmount;
        this.tail.f_104202_ = 2.0f + limbSwingAmount * 2.0f;
        this.tail.f_104204_ = movingTail ? Mth.m_14089_((float)(tickCountNextValue * 0.7f)) : 0.0f;
        this.rightHindBabyLeg.f_104201_ = this.rightHindLeg.f_104201_;
        this.rightHindBabyLeg.f_104202_ = this.rightHindLeg.f_104202_;
        this.rightHindBabyLeg.f_104203_ = this.rightHindLeg.f_104203_;
        this.leftHindBabyLeg.f_104201_ = this.leftHindLeg.f_104201_;
        this.leftHindBabyLeg.f_104202_ = this.leftHindLeg.f_104202_;
        this.leftHindBabyLeg.f_104203_ = this.leftHindLeg.f_104203_;
        this.rightFrontBabyLeg.f_104201_ = this.rightFrontLeg.f_104201_;
        this.rightFrontBabyLeg.f_104202_ = this.rightFrontLeg.f_104202_;
        this.rightFrontBabyLeg.f_104203_ = this.rightFrontLeg.f_104203_;
        this.leftFrontBabyLeg.f_104201_ = this.leftFrontLeg.f_104201_;
        this.leftFrontBabyLeg.f_104202_ = this.leftFrontLeg.f_104202_;
        this.leftFrontBabyLeg.f_104203_ = this.leftFrontLeg.f_104203_;
        boolean isBabyHorse = abstractHorse.m_6162_();
        this.rightHindLeg.f_104207_ = !isBabyHorse;
        this.leftHindLeg.f_104207_ = !isBabyHorse;
        this.rightFrontLeg.f_104207_ = !isBabyHorse;
        this.leftFrontLeg.f_104207_ = !isBabyHorse;
        this.rightHindBabyLeg.f_104207_ = isBabyHorse;
        this.leftHindBabyLeg.f_104207_ = isBabyHorse;
        this.rightFrontBabyLeg.f_104207_ = isBabyHorse;
        this.leftFrontBabyLeg.f_104207_ = isBabyHorse;
        this.body.f_104201_ = isBabyHorse ? 10.8f : 0.0f;
    }
}

