/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.sleepy_hollows.core.block.custom.TombstoneBlock;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsUtil;
import org.jetbrains.annotations.NotNull;

public class BigTombstoneBlock
extends TombstoneBlock {
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;

    public BigTombstoneBlock(BlockBehaviour.Properties properties) {
        super(properties, TombstoneBlock.createMidTombstoneShape());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        if (context.m_43725_().m_8055_(pos.m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)Half.BOTTOM);
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)Half.TOP), 3);
    }

    public void m_5707_(@NotNull Level world, @NotNull BlockPos pos, BlockState state, @NotNull Player player) {
        if (state.m_61143_(HALF) == Half.BOTTOM) {
            BlockPos topPos = pos.m_7494_();
            BlockState topState = world.m_8055_(topPos);
            if (topState.m_60734_() == this && topState.m_61143_(HALF) == Half.TOP) {
                world.m_46961_(topPos, false);
            }
        } else {
            BlockPos bottomPos = pos.m_7495_();
            BlockState bottomState = world.m_8055_(bottomPos);
            if (bottomState.m_60734_() == this && bottomState.m_61143_(HALF) == Half.BOTTOM) {
                world.m_46961_(bottomPos, false);
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        VoxelShape shape = state.m_61143_(HALF) == Half.BOTTOM ? TombstoneBlock.createBigTombstoneShapeBottom() : TombstoneBlock.createBigTombstoneShapeTop();
        return SleepyHollowsUtil.rotateShape(Direction.NORTH, facing, shape);
    }
}

