/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.block.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.sleepy_hollows.core.block.custom.entity.CoffinBlockEntity;
import net.satisfy.sleepy_hollows.core.block.custom.entity.DummyCoffinBlockEntity;
import net.satisfy.sleepy_hollows.core.registry.EntityTypeRegistry;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffinBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING;
    public static final BooleanProperty WATERLOGGED;
    public static final EnumProperty<BedPart> BED_PART;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    public static final Map<Direction, VoxelShape> SHAPE;

    public CoffinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(BED_PART, (Comparable)BedPart.HEAD));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockEntity blockEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos blockEntityPos = pos;
        if (state.m_61143_(BED_PART) == BedPart.FOOT) {
            blockEntityPos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        }
        if ((blockEntity = level.m_7702_(blockEntityPos)) instanceof CoffinBlockEntity) {
            player.m_5893_((MenuProvider)((CoffinBlockEntity)blockEntity));
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? CoffinBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.COFFIN_BLOCK_ENTITY.get()), CoffinBlockEntity::lidAnimateTick) : null;
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, isMoving);
            return;
        }
        if (state.m_61143_(BED_PART) == BedPart.HEAD && (blockEntity = level.m_7702_(pos)) instanceof CoffinBlockEntity) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        ItemStack itemStack = super.m_7397_(blockGetter, blockPos, blockState);
        blockGetter.m_141902_(blockPos, (BlockEntityType)EntityTypeRegistry.COFFIN_BLOCK_ENTITY.get()).ifPresent(cofferBlockEntity -> cofferBlockEntity.m_187476_(itemStack));
        return itemStack;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7278_(@NotNull BlockState blockState) {
        return true;
    }

    public int m_6782_(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(blockPos));
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos clickedPos = context.m_8083_();
        BlockPos footPos = clickedPos.m_121945_(direction);
        Level level = context.m_43725_();
        if (level.m_8055_(footPos).m_60629_(context) && level.m_6857_().m_61937_(footPos)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(BED_PART, (Comparable)BedPart.HEAD)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(clickedPos).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_) {
            BlockEntity blockEntity;
            CompoundTag blockEntityTag;
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            BlockPos footPos = pos.m_121945_(facing);
            level.m_7731_(footPos, (BlockState)state.m_61124_(BED_PART, (Comparable)BedPart.FOOT), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
            if (stack.m_41782_() && (blockEntityTag = stack.m_41737_("BlockEntityTag")) != null && (blockEntity = level.m_7702_(pos)) instanceof CoffinBlockEntity) {
                ResourceLocation lootTable = new ResourceLocation(blockEntityTag.m_128461_("LootTable"));
                long lootTableSeed = blockEntityTag.m_128454_("LootTableSeed");
                ((CoffinBlockEntity)blockEntity).m_59626_(lootTable, lootTableSeed);
                blockEntity.m_6596_();
            }
        }
    }

    public void m_5707_(Level level, @NotNull BlockPos pos, BlockState state, @NotNull Player player) {
        BedPart part = (BedPart)state.m_61143_(BED_PART);
        BlockPos otherPartPos = part == BedPart.HEAD ? pos.m_121945_((Direction)state.m_61143_((Property)FACING)) : pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        BlockState otherPartState = level.m_8055_(otherPartPos);
        if (otherPartState.m_60713_((Block)this) && otherPartState.m_61143_(BED_PART) != part) {
            level.m_7731_(otherPartPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, otherPartPos, Block.m_49956_((BlockState)otherPartState));
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (state.m_61143_(BED_PART) == BedPart.HEAD) {
            return new CoffinBlockEntity(pos, state);
        }
        return new DummyCoffinBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, BED_PART});
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    static {
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.875, (double)0.0, (double)0.875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, SleepyHollowsUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
            }
        });
        FACING = HorizontalDirectionalBlock.f_54117_;
        WATERLOGGED = BlockStateProperties.f_61362_;
        BED_PART = BlockStateProperties.f_61391_;
    }
}

