/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.sleepy_hollows.core.block.custom.InfectedFlowerBlock;
import net.satisfy.sleepy_hollows.core.registry.MobEffectRegistry;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class InfectedTallFlowerBlock
extends TallFlowerBlock {
    public static final BooleanProperty INFECTED = BooleanProperty.m_61465_((String)"infected");

    public InfectedTallFlowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)INFECTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52858_, INFECTED});
    }

    public void m_214162_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.m_61143_((Property)INFECTED)).booleanValue()) {
            VoxelShape voxelShape = this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
            Vec3 center = voxelShape.m_83215_().m_82399_();
            double x = (double)pos.m_123341_() + center.f_82479_;
            double z = (double)pos.m_123343_() + center.f_82481_;
            for (int i = 0; i < 3; ++i) {
                if (!random.m_188499_()) continue;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175833_, x + random.m_188500_() / 5.0, (double)pos.m_123342_() + (0.5 - random.m_188500_()), z + random.m_188500_() / 5.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_7892_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Player player;
        if (((Boolean)state.m_61143_((Property)INFECTED)).booleanValue() && !level.f_46443_ && level.m_46791_() != Difficulty.PEACEFUL && entity instanceof Player && !(player = (Player)entity).m_6673_(level.m_269111_().m_269251_())) {
            player.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.INFECTED.get(), 40));
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.m_21120_(hand).m_150930_((Item)ObjectRegistry.LUMINOUS_WATER.get()) && ((Boolean)state.m_61143_((Property)INFECTED)).booleanValue()) {
            this.deactivateNearbyFlowers(world, pos);
            world.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockPos.m_121990_((BlockPos)pos.m_7918_(-3, -3, -3), (BlockPos)pos.m_7918_(3, 3, 3)).forEach(p -> world.m_7106_((ParticleOptions)ParticleTypes.f_123804_, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, 0.0, 0.0, 0.0));
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private void deactivateNearbyFlowers(Level world, BlockPos pos) {
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-4, -4, -4), (BlockPos)pos.m_7918_(4, 4, 4)).forEach(p -> {
            BlockState state = world.m_8055_(p);
            if (state.m_60734_() instanceof InfectedFlowerBlock && ((Boolean)state.m_61143_((Property)INFECTED)).booleanValue()) {
                world.m_7731_(p, (BlockState)state.m_61124_((Property)INFECTED, (Comparable)Boolean.valueOf(false)), 3);
            }
        });
    }
}

