/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.sleepy_hollows.core.block.custom.entity.PedestalBlockEntity;
import net.satisfy.sleepy_hollows.core.entity.Horseman;
import net.satisfy.sleepy_hollows.core.registry.EntityTypeRegistry;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PedestalBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)PedestalBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{PedestalBlock.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), PedestalBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    private static long lastUseTime = 0L;

    public PedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof PedestalBlockEntity)) {
            return InteractionResult.PASS;
        }
        PedestalBlockEntity displayBlockEntity = (PedestalBlockEntity)blockEntity;
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastUseTime < 300000L) {
            return InteractionResult.PASS;
        }
        ItemStack stackInHand = player.m_21120_(hand);
        if (!stackInHand.m_41619_()) {
            if (!level.f_46443_ && displayBlockEntity.getDisplayedItem().m_41619_()) {
                ItemStack singleItemStack = stackInHand.m_41777_();
                singleItemStack.m_41764_(1);
                if (displayBlockEntity.setDisplayedItem(singleItemStack)) {
                    if (!player.m_150110_().f_35937_) {
                        stackInHand.m_41774_(1);
                    }
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                    level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (singleItemStack.m_150930_((Item)ObjectRegistry.LUMINOUS_ESSENCE.get())) {
                        BlockPos spawnPos = pos.m_122013_(5);
                        Horseman horseman = (Horseman)((EntityType)EntityTypeRegistry.HORSEMAN.get()).m_20615_(level);
                        if (horseman != null) {
                            LightningBolt lightningBolt2;
                            horseman.m_6034_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
                            level.m_7967_((Entity)horseman);
                            LightningBolt lightningBolt1 = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                            if (lightningBolt1 != null) {
                                lightningBolt1.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
                                lightningBolt1.m_20874_(true);
                                level.m_7967_((Entity)lightningBolt1);
                            }
                            if ((lightningBolt2 = (LightningBolt)EntityType.f_20465_.m_20615_(level)) != null) {
                                lightningBolt2.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                                lightningBolt2.m_20874_(true);
                                level.m_7967_((Entity)lightningBolt2);
                            }
                            displayBlockEntity.removeDisplayedItem(1);
                            level.m_5594_(null, pos, SoundEvents.f_12089_, SoundSource.WEATHER, 1.0f, 1.0f);
                        }
                        lastUseTime = currentTime;
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.CONSUME;
        }
        if (!displayBlockEntity.getDisplayedItem().m_41619_() && !level.f_46443_) {
            ItemStack displayedItem = displayBlockEntity.getDisplayedItem().m_41777_();
            if (!player.m_36356_(displayedItem)) {
                ItemEntity itemEntity = new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), displayedItem);
                level.m_7967_((Entity)itemEntity);
            }
            displayBlockEntity.removeDisplayedItem(1);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            level.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof PedestalBlockEntity) {
                PedestalBlockEntity displayBlockEntity = (PedestalBlockEntity)blockEntity;
                displayBlockEntity.dropContents();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PedestalBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE});
    }
}

