/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBlock
extends IronBarsBlock {
    public static final IntegerProperty PART = IntegerProperty.m_61631_((String)"part", (int)0, (int)3);

    public WindowBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52309_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52310_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52311_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52312_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52313_, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6402_(Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        if (!world.m_5776_()) {
            this.updateWindows((LevelAccessor)world, pos, state);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)f_52313_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    private void updateWindows(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockPos lowest = this.getLowestWindow(world, pos);
        BlockPos highest = this.getHighestWindow(world, pos);
        int height = 0;
        BlockPos current = lowest;
        while (current.compareTo((Vec3i)highest) <= 0) {
            ++height;
            current = current.m_7494_();
        }
        if (height == 1) {
            world.m_7731_(lowest, (BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(0)), 3);
        } else if (height == 2) {
            world.m_7731_(lowest, (BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(1)), 3);
            world.m_7731_(highest, (BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(3)), 3);
        } else {
            world.m_7731_(lowest, (BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(1)), 3);
            current = lowest.m_7494_();
            while (current.compareTo((Vec3i)highest) < 0) {
                world.m_7731_(current, (BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(2)), 3);
                current = current.m_7494_();
            }
            world.m_7731_(highest, (BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(3)), 3);
        }
    }

    private BlockPos getLowestWindow(LevelAccessor world, BlockPos pos) {
        while (world.m_8055_(pos.m_7495_()).m_60734_() == this) {
            pos = pos.m_7495_();
        }
        return pos;
    }

    private BlockPos getHighestWindow(LevelAccessor world, BlockPos pos) {
        while (world.m_8055_(pos.m_7494_()).m_60734_() == this) {
            pos = pos.m_7494_();
        }
        return pos;
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
        if (!world.m_5776_()) {
            this.updatePartOnNeighborChange(world, pos, state);
        }
    }

    private void updatePartOnNeighborChange(Level world, BlockPos pos, BlockState state) {
        boolean hasAbove;
        boolean hasBelow = world.m_8055_(pos.m_7495_()).m_60734_() == this;
        boolean bl = hasAbove = world.m_8055_(pos.m_7494_()).m_60734_() == this;
        if (!hasBelow && !hasAbove) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(0)), 3);
        } else if (!hasBelow) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(1)), 3);
        } else if (!hasAbove) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)PART, (Comparable)Integer.valueOf(3)), 3);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, f_52309_, f_52310_, f_52312_, f_52311_, f_52313_});
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }
}

