/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.satisfy.sleepy_hollows.core.entity.EntityWithAttackAnimation;
import net.satisfy.sleepy_hollows.core.entity.FleeingPumpkinHead;
import net.satisfy.sleepy_hollows.core.entity.ai.AnimationAttackGoal;
import net.satisfy.sleepy_hollows.core.entity.ai.NearestAttackablePlayerGoal;
import net.satisfy.sleepy_hollows.core.entity.ai.RandomAction;
import net.satisfy.sleepy_hollows.core.entity.ai.RandomActionGoal;
import net.satisfy.sleepy_hollows.core.entity.animation.ServerAnimationDurations;
import net.satisfy.sleepy_hollows.core.registry.EntityTypeRegistry;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import net.satisfy.sleepy_hollows.core.registry.SoundEventRegistry;
import net.satisfy.sleepy_hollows.core.util.ParticleArc;
import net.satisfy.sleepy_hollows.core.util.SoulfireSpiral;
import net.satisfy.sleepy_hollows.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class Horseman
extends Monster
implements EntityWithAttackAnimation,
PowerableMob {
    private static final EntityDataAccessor<Boolean> IMMUNE = SynchedEntityData.m_135353_(Horseman.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float[] HEALTH_THRESHOLDS = new float[]{0.75f, 0.5f, 0.25f};
    private static final EntityDataAccessor<Boolean> HAS_ACTIVE_PUMPKIN_HEAD = SynchedEntityData.m_135353_(Horseman.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Horseman.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LAUGHING = SynchedEntityData.m_135353_(Horseman.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"entity.sleepy_hollows.horseman"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
    private final List<ParticleArc> activeParticleArcs = new ArrayList<ParticleArc>();
    public AnimationState laughingAnimationState = new AnimationState();
    private int nextSummonIndex = 0;
    private int idleAnimationTimeout = 0;
    private int skeletonSpawnTimer = 500;
    private int attackCounter = 0;
    private final List<SoulfireSpiral> activeSoulfireSpirals = new ArrayList<SoulfireSpiral>();
    private int nextSoulfireIndex = 0;

    public Horseman(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.m_6593_((Component)Component.m_237115_((String)"entity.sleepy_hollows.horseman"));
        this.m_20340_(true);
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(0, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new AnimationAttackGoal(this, 1.0, true, (int)(ServerAnimationDurations.horseman_attack * 20.0f + 2.0f), 8));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackablePlayerGoal((Mob)this, 30.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomActionGoal(new RandomAction(){

            @Override
            public boolean isInterruptable() {
                return false;
            }

            @Override
            public void onStart() {
                Horseman.this.setLaughing(true);
            }

            @Override
            public void onStop() {
                Horseman.this.setLaughing(false);
            }

            @Override
            public boolean isPossible() {
                return true;
            }

            @Override
            public void onTick(int tick) {
                if (tick == 2) {
                    Horseman.this.m_9236_().m_6269_(null, (Entity)Horseman.this, (SoundEvent)SoundEventRegistry.HORSEMAN_LAUGH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }

            @Override
            public int duration() {
                return (int)(ServerAnimationDurations.horseman_laugh * 20.0f);
            }

            @Override
            public float chance() {
                return 0.01f;
            }

            @Override
            public AttributeInstance getAttribute(Attribute movementSpeed) {
                return Horseman.this.m_21051_(movementSpeed);
            }
        }));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 25.0f));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, PlatformHelper.getHorsemanMovementSpeed()).m_22268_(Attributes.f_22276_, PlatformHelper.getHorsemanMaxHealth()).m_22268_(Attributes.f_22281_, PlatformHelper.getHorsemanAttackDamage()).m_22268_(Attributes.f_22282_, PlatformHelper.getHorsemanAttackKnockback()).m_22268_(Attributes.f_22284_, PlatformHelper.getHorsemanArmor());
    }

    public void m_8119_() {
        Iterator<Object> iterator;
        float[] SOULFIRE_THRESHOLDS;
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.hasActivePumpkinHead() && !this.isPumpkinHeadAlive()) {
            this.setActivePumpkinHead(false);
        }
        if (!this.m_9236_().m_5776_() && this.hasActivePumpkinHead()) {
            this.m_9236_().m_7605_((Entity)this, (byte)10);
        }
        if (this.isMoving()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123790_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        float currentHealthRatio = this.m_21223_() / this.m_21233_();
        if (this.nextSummonIndex < HEALTH_THRESHOLDS.length && currentHealthRatio <= HEALTH_THRESHOLDS[this.nextSummonIndex]) {
            this.summonPumpkinHead();
            ++this.nextSummonIndex;
        }
        if (!this.m_9236_().m_5776_()) {
            --this.skeletonSpawnTimer;
            if (this.skeletonSpawnTimer <= 0) {
                this.spawnArmoredSkeleton();
                this.skeletonSpawnTimer = 500;
            }
        }
        if (this.nextSoulfireIndex < (SOULFIRE_THRESHOLDS = this.getSoulfireThresholds()).length && this.m_21223_() <= SOULFIRE_THRESHOLDS[this.nextSoulfireIndex]) {
            this.castSoulfireSpiral();
            ++this.nextSoulfireIndex;
        }
        if (!this.m_9236_().m_5776_() && !this.activeSoulfireSpirals.isEmpty()) {
            iterator = this.activeSoulfireSpirals.iterator();
            while (iterator.hasNext()) {
                SoulfireSpiral spiral = (SoulfireSpiral)iterator.next();
                spiral.tick();
                if (!spiral.isFinished()) continue;
                iterator.remove();
            }
        }
        if (!this.activeParticleArcs.isEmpty()) {
            iterator = this.activeParticleArcs.iterator();
            while (iterator.hasNext()) {
                ParticleArc arc = (ParticleArc)iterator.next();
                arc.tick(this.m_9236_());
                if (!arc.isFinished()) continue;
                iterator.remove();
            }
        }
        if (this.hasActivePumpkinHead()) {
            for (int i = 0; i < 3; ++i) {
                double offsetX = this.m_20185_() + this.f_19796_.m_188583_() * 0.3;
                double offsetY = this.m_20186_() + 1.0 + this.f_19796_.m_188583_() * 0.3;
                double offsetZ = this.m_20189_() + this.f_19796_.m_188583_() * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, offsetX, offsetY, offsetZ, 0.0, 0.0, 0.0);
                if (this.f_19796_.m_188503_(4) != 0) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, offsetX, offsetY, offsetZ, 0.7, 0.7, 0.5);
            }
        }
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    private void castSoulfireSpiral() {
        SoulfireSpiral spiral = new SoulfireSpiral(this.m_9236_(), this.m_20182_());
        this.activeSoulfireSpirals.add(spiral);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11702_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    private boolean isMoving() {
        return this.m_20184_().m_82556_() > 0.01;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    private void summonPumpkinHead() {
        if (!this.hasActivePumpkinHead()) {
            this.setActivePumpkinHead(true);
        }
        Vec3 spawnPos = this.m_20182_().m_82520_(0.0, 1.5, 0.0);
        FleeingPumpkinHead pumpkinHead = (FleeingPumpkinHead)((EntityType)EntityTypeRegistry.FLEEING_PUMPKIN_HEAD.get()).m_20615_(this.m_9236_());
        if (pumpkinHead != null) {
            pumpkinHead.m_6034_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_());
            pumpkinHead.setSummoner(this);
            this.m_9236_().m_7967_((Entity)pumpkinHead);
            this.f_19804_.m_135381_(IMMUNE, (Object)true);
            pumpkinHead.startFlyingAway();
        }
    }

    private void spawnArmoredSkeleton() {
        Vec3 spawnPos = this.m_20182_().m_82520_(this.f_19796_.m_188583_() * 8.0, 0.0, this.f_19796_.m_188583_() * 8.0);
        Skeleton skeleton = (Skeleton)EntityType.f_20524_.m_20615_(this.m_9236_());
        if (skeleton != null) {
            skeleton.m_6034_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_());
            skeleton.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_HELMET.get()));
            skeleton.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_CHESTPLATE.get()));
            skeleton.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_LEGGINGS.get()));
            skeleton.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ObjectRegistry.HAUNTBOUND_BOOTS.get()));
            skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
            skeleton.m_6593_((Component)Component.m_237115_((String)"entity.sleepy_hollows.hauntbound_skeleton"));
            skeleton.m_20340_(false);
            this.m_9236_().m_7967_((Entity)skeleton);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_ACTIVE_PUMPKIN_HEAD, (Object)false);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(IMMUNE, (Object)false);
        this.f_19804_.m_135372_(LAUGHING, (Object)false);
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        this.attackAnimationState.m_246184_(this.isAttacking(), this.f_19797_);
        this.laughingAnimationState.m_246184_(this.isLaughing(), this.f_19797_);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    public void setAttacking_(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    private boolean isLaughing() {
        return (Boolean)this.f_19804_.m_135370_(LAUGHING);
    }

    public void setLaughing(boolean laughing) {
        this.f_19804_.m_135381_(LAUGHING, (Object)laughing);
    }

    @Override
    public Vec3 getPosition_(int i) {
        return super.m_20318_((float)i);
    }

    @Override
    public void doHurtTarget_(LivingEntity targetEntity) {
        super.m_7327_((Entity)targetEntity);
        ++this.attackCounter;
        if (this.attackCounter >= 7) {
            this.removeWaterInRadius();
            this.attackCounter = 0;
        }
    }

    @Override
    public LivingEntity getTarget_() {
        return this.m_5448_();
    }

    @Override
    public double getMeleeAttackRangeSqr_(LivingEntity entity) {
        return super.m_142593_(entity);
    }

    private boolean isPumpkinHeadAlive() {
        AABB searchArea = this.m_20191_().m_82400_(100.0);
        return !this.m_9236_().m_6443_(FleeingPumpkinHead.class, searchArea, Entity::m_6084_).isEmpty();
    }

    public boolean hasActivePumpkinHead() {
        return (Boolean)this.f_19804_.m_135370_(HAS_ACTIVE_PUMPKIN_HEAD);
    }

    public void setActivePumpkinHead(boolean active) {
        this.f_19804_.m_135381_(HAS_ACTIVE_PUMPKIN_HEAD, (Object)active);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("HasActivePumpkinHead", this.hasActivePumpkinHead());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.setActivePumpkinHead(true);
        } else if (id == 11) {
            this.setActivePumpkinHead(false);
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.isPumpkinHeadAlive()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        for (int i = 0; i < 70; ++i) {
            double offsetX = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double offsetY = this.m_20186_() + this.f_19796_.m_188500_() * 2.0;
            double offsetZ = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, offsetX, offsetY, offsetZ, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, offsetX, offsetY, offsetZ, 0.0, 0.0, 0.0);
        }
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            int experienceAmount = 250;
            ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20182_(), (int)experienceAmount);
        }
    }

    private void removeWaterInRadius() {
        AABB area = new AABB(this.m_20183_()).m_82400_(10.0);
        BlockPos.m_121921_((AABB)area).forEach(pos -> {
            if (this.m_9236_().m_6425_(pos).m_76170_()) {
                if (this.m_9236_().m_5776_()) {
                    this.m_9236_().m_46796_(2001, pos, Block.m_49956_((BlockState)this.m_9236_().m_8055_(pos)));
                }
                this.m_9236_().m_7731_(pos, ((Block)ObjectRegistry.GRAVESTONE.get()).m_49966_(), 3);
                if (this.m_9236_().m_5776_()) {
                    Vec3 targetPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                    Vec3 horsemanPos = new Vec3(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                    ParticleArc arc = new ParticleArc(targetPos, horsemanPos, 40);
                    this.activeParticleArcs.add(arc);
                }
            }
        });
    }

    public void m_147240_(double strength, double xRatio, double zRatio) {
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundEventRegistry.HORSEMAN_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)SoundEventRegistry.HORSEMAN_HIT.get();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12425_;
    }

    private float[] getSoulfireThresholds() {
        float maxHealth = this.m_21233_();
        float[] thresholds = new float[10];
        for (int i = 0; i < 10; ++i) {
            thresholds[i] = maxHealth * (1.0f - (float)i * 0.1f);
        }
        return thresholds;
    }

    public boolean m_6149_() {
        return true;
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(IMMUNE);
    }

    protected void m_7472_(@NotNull DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        List<ItemStack> horsemanLoot = PlatformHelper.getHorsemanLootItems();
        for (ItemStack loot : horsemanLoot) {
            this.m_19983_(loot);
        }
    }
}

