/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.item.custom;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.satisfy.sleepy_hollows.core.registry.ToolTiersRegistry;
import net.satisfy.sleepy_hollows.core.util.EnchantingBehavior;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpectralWarAxeItem
extends AxeItem
implements EnchantingBehavior {
    public SpectralWarAxeItem(Item.Properties properties) {
        super((Tier)ToolTiersRegistry.SPECTRAL, 3.3f, -2.8f, properties);
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return !EnchantmentHelper.m_44831_((ItemStack)book).containsKey(Enchantments.f_44981_) && EnchantingBehavior.super.isBookEnchantable(stack, book);
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        Level level;
        boolean result = super.m_7579_(stack, target, attacker);
        if (result && !target.m_20193_().m_5776_()) {
            double originalArmor = Objects.requireNonNull(target.m_21051_(Attributes.f_22284_)).m_22135_();
            double armorPenetration = originalArmor * 0.5;
            double damageWithoutArmor = Objects.requireNonNull(attacker.m_21051_(Attributes.f_22281_)).m_22135_();
            double finalDamage = damageWithoutArmor - armorPenetration / 5.0;
            target.m_6469_(attacker.m_9236_().m_269111_().m_269333_(attacker), (float)finalDamage);
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120, 0));
        }
        if (!target.m_9236_().f_46443_ && (level = target.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 10; ++i) {
                double px = target.m_20185_() + target.m_20154_().f_82479_;
                double py = target.m_20186_() + (double)target.m_20206_();
                double pz = target.m_20189_() + target.m_20154_().f_82481_;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123790_, px, py, pz, 1, 0.0, 0.0, 0.0, 0.02);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, px, py, pz, 1, 0.0, 0.0, 0.0, 0.02);
            }
        }
        return result;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.sleepy_hollows.lore.spectral_waraxe").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC}));
    }
}

