/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.satisfy.sleepy_hollows.core.effect.BadDreamEffect;
import net.satisfy.sleepy_hollows.core.effect.InfectedEffect;
import net.satisfy.sleepy_hollows.core.effect.InsanityEffect;
import net.satisfy.sleepy_hollows.core.effect.MentalFortitudeEffect;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsIdentifier;

public class MobEffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"sleepy_hollows", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> INSANITY = MobEffectRegistry.registerEffect("insanity", InsanityEffect::new);
    public static final RegistrySupplier<MobEffect> INFECTED = MobEffectRegistry.registerEffect("infected", InfectedEffect::new);
    public static final RegistrySupplier<MobEffect> MENTAL_FORTITUDE = MobEffectRegistry.registerEffect("mental_fortitude", MentalFortitudeEffect::new);
    public static final RegistrySupplier<MobEffect> BAD_DREAM = MobEffectRegistry.registerEffect("bad_dream", BadDreamEffect::new);

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new SleepyHollowsIdentifier(name), effect);
    }

    public static void init() {
        MOB_EFFECTS.register();
    }
}

