/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.forge;

import dev.architectury.platform.forge.EventBuses;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.satisfy.sleepy_hollows.Constants;
import net.satisfy.sleepy_hollows.SleepyHollows;
import net.satisfy.sleepy_hollows.core.registry.CompostableRegistry;
import net.satisfy.sleepy_hollows.core.world.SleepyHollowsRegion;
import net.satisfy.sleepy_hollows.forge.config.SleepyHollowsForgeConfig;

@Mod(value="sleepy_hollows")
public final class SleepyHollowsForge {
    public SleepyHollowsForge() {
        EventBuses.registerModEventBus((String)"sleepy_hollows", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        SleepyHollows.init();
        SleepyHollowsForgeConfig.loadConfig(SleepyHollowsForgeConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("sleepyhollows.toml").toString());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register((Object)this);
        modEventBus.addListener(this::onCommonSetup);
        Constants.LOG.info("Sleepy Hollows initialized successfully on the Forge platform.");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(SleepyHollowsRegion::loadTerrablender);
        SleepyHollows.commonInit();
    }

    @SubscribeEvent
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(CompostableRegistry::init);
    }

    @Mod.EventBusSubscriber(modid="sleepy_hollows", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class SleepyHollowsEventHandlers {
        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
                MinecraftServer server = event.getServer();
                SleepyHollows.onServerTick(server);
            }
        }
    }
}

